#ifndef _WFST_H_
#define _WFST_H_

#include <boost/filesystem/path.hpp>
#include <string>
#include <outilex/basic_fst.h>
#include <outilex/generic_fst.h>
#include <outilex/xml.h>
#include <outilex/wfst_symbols.h>

struct wfst_output {

  int out;
  double weight;

  wfst_output() : out(0), weight(0.) {}
  wfst_output(int o, double w) : out(o), weight(w) {}
  wfst_output(const std::string & text); // 5:0.7
  wfst_output(const std::string & text, const wfst_symbols & alph); // vert:0.7

  void write_xml(xmlwriter & writer) const;
  void read_xml(xmlNode * node);

};

inline bool operator<(const wfst_output & a, const wfst_output & b) {
  if (a.weight != b.weight) { return a.weight < b.weight; }
  return a.out < b.out;
}

class wfst : public basic_fst<int, wfst_output> {

public:
  typedef basic_fst<int, wfst_output> fst_type;

  wfst() : fst_type() {}

  wfst(const generic_fst & fst) : fst_type() { load(fst); }
  wfst(const generic_fst & fst, const wfst_symbols & alph) : fst_type() { load(fst, alph); }

  void load(const generic_fst & fst);
  void load(const generic_fst & fst, const wfst_symbols & alph);

  //XML 
  wfst(const boost::filesystem::path & path);

  void write_xml(xmlwriter & writer) const;
  void read_xml(xmlNode *);

  void read(const boost::filesystem::path & path);
  void write(const boost::filesystem::path & path) const;
};

#endif
