#ifndef _UNIQUE_SEQUENCE_H_
#define _UNIQUE_SEQUENCE_H_

#include <set>
#include <vector>
#include <boost/iterator/indirect_iterator.hpp>


template<typename Value,
         typename Compare = std::less<Value> >
class unique_sequence {

public:

  typedef Value value_type;
  typedef Compare key_compare;
  typedef std::set<value_type, Compare> set_type;
  typedef std::vector<typename set_type::iterator> vector_type;

  typedef boost::indirect_iterator<typename vector_type::iterator> iterator;
  typedef boost::indirect_iterator<typename vector_type::const_iterator> const_iterator;

  typedef typename set_type::iterator val_iterator;

  unique_sequence() : items(), tab() {}
  unique_sequence(const key_compare & comp) : items(comp), tab() {}

  int size() const { return tab.size(); }

  //  value_type & operator[](int idx) { return *(tab[idx]); }  
  const value_type & operator[](int idx) const { return *(tab[idx]); }

  iterator begin() { return iterator(tab.begin()); }
  iterator end()   { return iterator(tab.end()); }

  const_iterator begin() const { return const_iterator(tab.begin()); }
  const_iterator end()   const { return const_iterator(tab.end());   }

  // find a particular value
  val_iterator find(const value_type & v) const { return items.find(v); }
  val_iterator val_end() const { return items.end(); }

  val_iterator lower_bound(const value_type & v) const { return items.lower_bound(v); }


  // return the index of the added element,
  // or -1 if already present
  int add(const value_type & i) {
    std::pair<typename set_type::iterator, bool> p = items.insert(i);    
    if (p.second == false) { return -1; }
    tab.push_back(p.first);
    return tab.size() - 1;
  }

  set_type items;
  vector_type tab;
};


#endif
