#ifndef _STRINGTOK_H_
#define _STRINGTOK_H_

#include <string>

template<typename Container>
void stringtok_in_container(Container & cont, const std::string & in, const char * delim) {

  const std::string::size_type len = in.length();
  std::string::size_type i = 0;

  while (i < len) {

    i = in.find_first_not_of(delim, i);

    if (i == std::string::npos) return;

    std::string::size_type j = in.find_first_of(delim, i);

    if (j == std::string::npos) {
      cont.push_back(in.substr(i));
      return;
    } else {
      cont.push_back(in.substr(i, j - i));
    }
    i = j + 1;
  }
}

/* more generic implementation (use output iterator instead of container)
 */

template<typename OutputIterator>
void stringtok(const std::string & in, const char * delim, OutputIterator it) {

  const std::string::size_type len = in.length();
  std::string::size_type i = 0;

  while (i < len) {

    i = in.find_first_not_of(delim, i);

    if (i == std::string::npos) return;

    std::string::size_type j = in.find_first_of(delim, i);

    if (j == std::string::npos) {
      *it = in.substr(i); ++it;
      return;
    } else {
      *it = in.substr(i, j - i); ++it;
    }
    i = j + 1;
  }
}

template<typename OutputIterator>
void stringtok(const std::string & in, char delim, OutputIterator it) {
  char buf[] = { 0, 0 };
  buf[0] = delim;
  stringtok(in, buf, it); 
}


#endif

