#ifndef _SEMIRING_TRAITS_H_
#define _SEMIRING_TRAITS_H_

// non standard SGI extension (copy from GNU ext/functional header)

template <class _Tp> inline _Tp identity_element(std::plus<_Tp>) {
  return _Tp(0);
}

template <class _Tp> inline _Tp identity_element(std::multiplies<_Tp>) {
  return _Tp(1);
}

// exemple of semiring traits implementation on integer

template<typename T>
struct default_semiring_traits {

  typedef T value_type;

  static value_type plus(const value_type & a, const value_type & b) { return a + b; }
  static value_type multiplies(const value_type & a, const value_type & b) { return a * b; }

  static const value_type & zero() { return _zero; }
  static const value_type & one()  { return _one; }

  static const value_type _zero = value_type(0);
  static const value_type _one  = value_type(1);
};


template<typename T, typename Addition = std::plus<T>, typename Multiplication = std::multiplies<T> >
semiring_operations {

  typedef T value_type;
  typedef Addition addition;
  typedef Multiplication multiplication;

  addition plus;
  multiplication multiplies;

  inline semi_ring_traits(const addition & add = addition(), const multiplication & mult = multiplication())
    : plus_(add), multiplies(mult) {}


  inline value_type zero() { return identity_element(plus); }
  inline value_type one()  { return identity_element(multiplies); }
};

#endif

