#ifndef _PROPERTY_MAP_H_
#define _PROPERTY_MAP_H_

#include <map>
#include <boost/any.hpp>


struct property_map {
  std::map<std::string, boost::any> properties;

  property_map() : properties() {}


  template<typename ValueType>
  void set(const std::string & prop, const ValueType & val) {
    properties[prop] = val;
  }

  template<typename ValueType>
  ValueType * get(const std::string & prop) const {
    std::map<std::string, boost::any>::const_iterator it = properties.find(prop);
    if (it == properties.end()) { return 0; }
    return boost::any_cast<ValueType>(& it->second);
  }

  template<typename ValueType>
  bool get(const std::string & prop, ValueType & val) const {
    const ValueType * ptr = get(prop);
    if (ptr == 0) { return false; }
    val = *ptr;
    return true;
  }

  bool has(const std::string & prop) { return properties.find(prop) != properties.end(); }

};

#endif
