// null_ouptut_iterator, adapted from boost's function_output_iterator
// (C) Copyright Jeremy Siek 2001.
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Revision History:

// 27 Feb 2001   Jeremy Siek
//      Initial checkin.

#ifndef NULL_OUTPUT_ITERATOR_H
#define NULL_OUTPUT_ITERATOR_H

#include <iterator>


class null_output_iterator {

public:

  typedef std::output_iterator_tag iterator_category;

  typedef void value_type;
  typedef void difference_type;
  typedef void pointer;
  typedef void reference;

  null_output_iterator() {}

  struct output_proxy {
    template <class T> output_proxy& operator=(const T& value) {
      return *this; 
    }
  };

  output_proxy operator*() { return output_proxy(); }

  null_output_iterator & operator++() { return *this; } 
  null_output_iterator & operator++(int) { return *this; }
};


#endif
