#ifndef _DISPATCH_H_
#define _DISPATCH_H_

template<typename InputIterator,
         typename OutputIterator1, typename OutputIterator2,
         typename Predicate>
void dispatch(Predicate pred, InputIterator first, InputIterator last,
              OutputIterator1 yes, OutputIterator2 no) {
  
  while (first != last) {
    if (pred(*first)) {
      *yes = *first;
      ++yes;
    } else {
      *no = *first;
      ++no;
    }
    ++first;
  }
}

#endif

