#include <iostream>
#include <string>
#include <boost/regex.hpp>
#include <boost/regex/icu.hpp>

using namespace std;
using namespace boost;


int main() try {

  //u32regex expr(make_u32regex("(<[^>]*>|[[:alpha:]]+|[[:digit:]]+|[[:punct:]])"));
  u32regex expr(make_u32regex("(<[^>]*>|[[:L*:]]+|[[:Nd:]]+|[[:P*:]]|[[:S*:]])"));

  string line;
  while (getline(cin, line)) {
  
    //sregex_token_iterator i(line.begin(), line.end(), expr, 1), end;
    u32regex_token_iterator<string::const_iterator> 
      i(make_u32regex_token_iterator(line, expr, 1)), end;

    while (i != end) {
      cout << "'" << *i << "' "; 
      ++i;
    }
    cout << endl;
  }
} catch (exception & e) {
  cerr << "fatal error: " << e.what() << endl;
  exit(1);
}
