#include <iostream>
#include <string>
#include <boost/progress.hpp>

#include <outilex/stringtok.h>
#include <outilex/DELAentry.h>
#include <outilex/DELAcorresp.h>

using namespace std;
using namespace boost;


int main(int argc, char ** argv) try {
 
  if (argc < 2) {
    cerr << "bad args" << endl
      << "usage: " << *argv << " <correspondance file>\n";
    exit(1);
  }

  char * correspname = argv[1];


  DELAcorresp corresp(correspname);

  string form, lemma, cat, synt, flex;
  string L, F;

  set<string> unknow_codes;

  int nbline = 0;

  while (getDELAline(cin, form, lemma, cat, synt, flex)) {

    lemma += '.' + cat;

    const DELAcorresp::POS_inf & posinf = corresp[cat];

    set<string> codes;
    stringtok(synt, "+", inserter(codes, codes.begin()));

    for (set<string>::iterator c = codes.begin(); c != codes.end(); ++c) {

      bool withlemma = false, withform = false;
      DELAcorresp::synt_code_map::const_iterator it = posinf.SYNTs.find(*c);

      if (it != posinf.SYNTs.end()) {

        const vector<DELAcorresp::feat_def> & feats = it->second;

        for (int j = 0; j < feats.size(); j++) {
          if (feats[j].type == DELAcorresp::LEMMA_FEAT) {
            withlemma = true;
          } else { withform = true; }
        }

        if (withlemma) { lemma += '+' + *c; }
        if (withform)  { form  += '+' + *c; }
      } else {
        if (unknow_codes.find(*c) == unknow_codes.end()) {
          cerr << "unknow code " << *c << " in POS " << cat << endl;
          unknow_codes.insert(*c);
        }
      }
    }

    cout << lemma << '#' << form << flex << '\n';

    nbline++;
    if ((nbline % 10000) == 0) {
      cerr << ".";
      if ((nbline % 100000) == 0) { cerr <<  ' '; }
    }
  }

  cerr << '(' << nbline << " entries)\n";

  return 0;
} catch (exception & e) {
  cerr << "exception caught : " << e.what() << endl;
  exit(1);
}
