#include <iostream>
#include <string>
#include <set>
#include <vector>
#include <iterator>

#include <outilex/DELAentry.h>
#include <outilex/stringtok.h>

using namespace std;


struct feature {

  string code;
  mutable set<string> POSs;

  feature(string c) : code(c), POSs() {}

  friend bool operator< (const feature & a, const feature & b) { return (a.code < b.code); }
};


set<string> POSs;
set<feature> synts;
set<feature> flexs;

int nbentries;


int main() {
  
  string form, lemma, cat, synt, flex;

  while (getDELAline(cin, form, lemma, cat, synt, flex)) {

    nbentries++;

    POSs.insert(cat);

    /* syntactic features */

    vector<string> feats;
    stringtok(synt, "+", back_inserter(feats));

    for (int i = 0; i < feats.size(); i++) {
      set<feature>::iterator it = synts.insert(synts.begin(), feature(feats[i]));
      (*it).POSs.insert(cat);
    }

    /* inflexional */

    for (int i = 1; i < flex.size(); i++) {
    
      if (flex[i] == ':') { nbentries++; continue; }
 
      string code;
      code = flex[i];
 
      set<feature>::iterator it = flexs.insert(flexs.begin(), feature(code));
      (*it).POSs.insert(cat);
    }

    if ((nbentries % 10000) == 0) {
      cerr << '.' << flush;
      if ((nbentries % 100000) == 0) { cerr << ' ' << flush; }
    }
  }


  cerr << " done.\n";

  cerr << POSs.size() << " POSs, " << synts.size() << " syntactic codes & "
    << flexs.size() << " inflexionnal features\n";


  for (set<string>::iterator it = POSs.begin(); it != POSs.end(); ++it) {
    cout << "POS " << (*it) << '\n';
  }

  cout << '\n';

  for (set<feature>::iterator it = synts.begin(); it != synts.end(); ++it) {

    cout << "synt " << (*it).code <<  ' ';

    const set<string> & POSs = (*it).POSs;
    copy(POSs.begin(), POSs.end(), ostream_iterator<string>(cout, ","));

    cout << '\n';
  }
  cout << '\n';

  for (set<feature>::iterator it = flexs.begin(); it != flexs.end(); ++it) {
    cout << "flex " << (*it).code << ' ';
    const set<string> & POSs = (*it).POSs;
    copy(POSs.begin(), POSs.end(), ostream_iterator<string>(cout, ","));
    cout << '\n';
  }
}

