#include <iostream>
#include <string>
#include <set>
#include <vector>

#include <outilex/DELAentry.h>
#include <outilex/stringtok.h>

using namespace std;


int main() {
  
  int nbentries = 0;
  string form, lemma, cat, synt, flex;

  while (getDELAline(cin, form, lemma, cat, synt, flex)) {

    nbentries++;
    vector<string> flexs;
    stringtok(back_inserter(flexs), flex, ":");

    if (flexs.empty()) {
    
      cout << form << ',' << lemma << '.' << cat << synt << '\n';
    
    } else {

      for (int i = 0; i < flexs.size(); ++i) {
        cout << form << ',' << lemma << '.' << cat << synt << ':' << flexs[i] << '\n';
      }
    }

    if ((nbentries % 10000) == 0) {
      cerr << "." << flush;
      if ((nbentries % 100000) == 0) { cerr << ' ' << flush; }
    }
  }

  cerr << " done.\n";
}

