#!/bin/bash

set -e

#PATH=$PATH:.

if [ $# != 3 -o "$1" != "-c" ]; then
  echo "usage: $0 -c <corresp> <delaf>"
  exit 1
fi

#[ -z "$1" ] && echo "bad args" && exit 1

CORRESP=$2
DELAF=$3


[ ! -f "$CORRESP" ] && echo "corresp file '$CORRESP' not found" && exit 1
[ ! -f "$DELAF" ] && echo "DELAF file '$DELAF' not found" && exit 1

LEMMA1ST=/tmp/lemma1st-$$
DICOXML=$DELAF.xml.gz

echo "preliminary sort ..."
cat $DELAF | lemmafirst $CORRESP | sort > $LEMMA1ST
echo "done."

echo "XML translation (into $DICOXML) ..."
cat $LEMMA1ST | delaf2xml-bin $CORRESP | gzip >  $DICOXML
rm $LEMMA1ST
echo "done. XML dic stored in $DICOXML."

