#include <iostream>
#include <string>
#include <set>
#include <vector>
#include <iterator>

#include <boost/assign/list_of.hpp>

#include <outilex/DELAentry.h>
#include <outilex/stringtok.h>

using namespace std;
using namespace boost::assign;


int main() {
  
  set<string> to_keep = list_of("Dadj")
  ("Dadv") ("Ddef") ("Ddem") ("Dind") ("Dnom")
  ("Dposs1p") ("Dposs1s") ("Dposs2p") ("Dposs2s") ("Dposs3p") ("Dposs3s")
  ("PR")
  ("Pdem") ("Pind") ("Ppv") ("PpvIL") ("PpvLE") ("PpvLUI") ("Pred") ("PronQ") ("Ton")
  ("d") ("g") ("l");
  
  string form, lemma, cat, synt, flex;
  int nbentries = 0;

  while (getDELAline(cin, form, lemma, cat, synt, flex)) {

    /* syntactic features */

    cout << form << "," << lemma << "." << cat;

    vector<string> feats;
    stringtok(synt, "+", back_inserter(feats));

    for (int i = 0; i < feats.size(); i++) {
      if (to_keep.find(feats[i]) != to_keep.end()) {
        cout << "+" << feats[i];
      }
    }

    /* inflexional */

    cout << flex << "\n";

    ++nbentries;
    if ((nbentries % 10000) == 0) {
      cerr << '.' << flush;
      if ((nbentries % 100000) == 0) { cerr << ' ' << flush; }
    }
  }

  cerr << " done.\n";
}

