#include <iostream>
#include <string>
#include <boost/filesystem/convenience.hpp>

#include <outilex/string_transducer.h>

#include <outilex/FST2.h>
#include <outilex/FST2_to_string_transducer.h>


using namespace std;
namespace fs = boost::filesystem;


namespace {

struct transducer_symbol {

  typedef string_transducer::input_type      input_type;
  typedef string_transducer::output_type     output_type;

  enum { GOOD, BAD } type;

  vector<input_type>  in; // vector for <MOT> -> <?>, <N>, blablabla
  output_type out;
};

struct FST2_transducer_symbol_loader {

  typedef transducer_symbol symbol_type;
  typedef symbol_type::input_type  input_type;
  typedef symbol_type::output_type output_type;

  ling_def * lingdef;
  FST2_transducer_symbol_loader(ling_def * ldef) : lingdef(ldef) {}

  void operator()(const string & text, symbol_type & symb) {

    symb.in.clear();
    symb.type = symbol_type::BAD;

    if (text.empty()) { symb.type = symbol_type::BAD; return; }

    string::size_type slash = text.find('/');
    string in, out;

    if (slash != string::npos) {
      in = text.substr(0, slash);
      out = text.substr(slash + 1);
    } else {
      in = text;
    }

    // parse input label

    try {

      /* look for special UNITEX symbols first */

      if (in == "<!DIC>") {

        symb.in.push_back(lexical_mask(lingdef->unknow_pos()));
      
      } else if (in == "<MOT>") { // translate to <LEX>

        //symb.in.push_back(lexical_mask(lingdef->lex_pos()));
        symb.in.push_back(lexical_mask(lingdef->get_pos("lex")));
#if 0
        for (ling_def::const_pos_iterator p = lingdef->word_pos_begin();
             p != lingdef->pos_end(); ++p) {
          symb.in.push_back(lexical_mask(*p));
        }
#endif

      } else { // assume lexical mask

        symb.in.push_back(lexical_mask(in, lingdef));
      }

      if (out.empty()) {
        symb.out = symb.out.one();
      } else {
        symb.out.read_text(out);
      }

      symb.type = symbol_type::GOOD;

    } catch (exception & e) {
      cerr << "error cannot load FST symbol '" << text << "': " << e.what() << "\n";
      symb.type = symbol_type::BAD;
    }
  }
};


void str_transducer_add_transition(string_transducer & fst, int q,
                                   const transducer_symbol & symb, int dest) {
  if (symb.type == transducer_symbol::GOOD) {
    for (int i = 0; i < symb.in.size(); ++i) {
      fst.add_trans(q, symb.in[i], symb.out, dest);
    }
  } else {
    std::cerr << "bad transition label: type=" << symb.type << "\n";
  }
}

}; // anonymous namespace 


void FST2_to_string_transducer(const fs::path & fst_path, string_transducer & T) {

  cerr << "FST2_transducer : " << fst_path.native_file_string() << "\n";
  FST2_transducer_symbol_loader symbol_loader(T.get_lingdef());
  load_FST2(fst_path, T, symbol_loader, str_transducer_add_transition);

  for (int q = 0; q < T.size(); ++q) { // add epsilon in final_output
    if (T.final(q)) {
      T.final_outputs(q).insert(string_transducer::output_type::one());
    }
  }
}

void FST2_to_string_transducer(const fs::path & fst_path, const fs::path & out_path,
                               ling_def * lingdef) {
  string_transducer T(lingdef);
  FST2_to_string_transducer(fst_path, T);
  T.write(out_path);
}

