#include <iostream>
#include <string>
#include <boost/filesystem/convenience.hpp>

#include <outilex/generic_fst.h>

#include <outilex/FST2.h>
#include <outilex/FST2_to_string_transducer.h>


using namespace std;
namespace fs = boost::filesystem;


namespace {

struct generic_fst_symbol {

  enum { GOOD, BAD } type;

  string in;
  string out;
};


struct FST2_symbol_loader {

  typedef generic_fst_symbol symbol_type;


  void operator()(const string & text, symbol_type & symb) {

    string::size_type slash = text.find('/');

    if (slash != string::npos) {
      symb.in = text.substr(0, slash);
      symb.out = text.substr(slash + 1);
    } else {
      symb.in = text;
      symb.out = "";
    }
  }
};


void add_transition(generic_fst & fst, int q,
                    const generic_fst_symbol & symb, int dest) {
  fst.add_trans(q, symb.in, symb.out, dest);
}

}; // anonymous namespace 



void FST2_to_generic_fst(const fs::path & path, generic_fst & fst) {

  FST2_symbol_loader symbol_loader;
  load_FST2(path, fst, symbol_loader, add_transition);

  fst.name = fs::basename(path);
}


