#include <vector>
#include <stdexcept>
#include <boost/filesystem/path.hpp>
#include <outilex/text_uchart.h>

using namespace std;
namespace fs = boost::filesystem;

namespace {

struct chart_reader_item {
  ichart_guesser_f guess;
  ichart_creator_f create;
  chart_reader_item(ichart_guesser_f g, ichart_creator_f c) : guess(g), create(c) {}
};

typedef vector<chart_reader_item> readers_type;
readers_type * text_chart_readers = 0;

readers_type & get_readers() {
  if (text_chart_readers == 0) { text_chart_readers = new readers_type(); }
  return *text_chart_readers;
}

} // namespace ""


void register_text_chart_reader(ichart_guesser_f guess, ichart_creator_f create) {
  readers_type & readers = get_readers();
  readers.push_back(chart_reader_item(guess, create));
}

itext_uchart * new_itext_uchart(const fs::path & path, ling_def * lingdef) {
  readers_type & readers = get_readers();
  for (int i = 0; i < readers.size(); ++i) {
    if (readers[i].guess(path)) { return readers[i].create(path, lingdef); }
  }
  throw runtime_error("new_itext_uchart: invlid format for file " + path.string());
}


// LINKER stuff (see text_fsa.cpp)

itext_uchart::~itext_uchart() {}
otext_uchart::~otext_uchart() {}

// external formatter

extern int LINK_WITH_XML_TEXT_UCHART;
extern int LINK_WITH_FSA_TEXT_UCHART;


void __dumb_text_uchart_linker_helper__() {
  LINK_WITH_XML_TEXT_UCHART++;
  LINK_WITH_FSA_TEXT_UCHART++;
}



