#include <string>
#include <boost/variant.hpp>

#include <outilex/lingdef.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/synt_input_type.h>

using namespace std;
using namespace boost;
using namespace xmlnames;


synt_input_type::synt_input_type(const std::string & text, ling_def * ldef) : type(LEXMASK), v() {

  if (text.empty()) { throw runtime_error("parse error: empty input_type text description"); }
  
  if (text[0] == '<' && text[1] == ':') { // subgraph call (e.g. <:SN> -> SN)

    type = SUBCALL;
    v = text.substr(2, text.size() - 3);

  } else if (text == "<E>") {

    type = EPSILON;
    v = "";

  } else { // lexical_mask

    lexical_mask m(text, ldef);

    if (m.get_pos() == ldef->epsilon_pos()) {
      type = EPSILON;
      v = "";
    } else {
      type = LEXMASK;
      v = m;
    }
  }
}


void synt_input_type::write_xml(xmlwriter & writer) const {
  
  if (type == LEXMASK) {

    boost::get<lexical_mask>(v).write_XML(writer);

  } else if (type == EPSILON) {

    writer.write_element(EPSILON_ELEM, "");

  } else {
    writer.write_element(SUBCALL_ELEM, boost::get<string>(v));
  }
}


void synt_input_type::read_xml(xmlNodePtr node, ling_def * lingdef) {

  char * text;

  if (xmlStrcmp(node->name, SUBCALL_ELEM) == 0) {
 
    type = SUBCALL;
    text = (char *) xmlNodeGetContent(node);
    v = text;
    xmlFree(text);

  } else if (xmlStrcmp(node->name, EPSILON_ELEM) == 0) {
    type = EPSILON;
    v = "";
  } else {
  
    lexical_mask m(node, lingdef);
    if (m.get_pos() == lingdef->epsilon_pos()) {
      type = EPSILON;
      v = ""; 
    } else {
      type = LEXMASK;
      v = m;
    }
  }
}

