#ifndef _UPARSER_TWO_PASS_H_
#define _UPARSER_TWO_PASS_H_

#include <vector>
#include <set>
#include <map>

#include <outilex/wgb_color.h>
#include <outilex/usyntagm_pattern.h>
#include <outilex/ugrammar.h>
#include <outilex/sentence_fsa.h>

#include <outilex/cache_fst.h>
#include <outilex/uchart.h>



class uparser_twopass {

public:

  typedef ugrammar::input_type  input_type;
  typedef ugrammar::output_type output_type;


  uparser_twopass(const ugrammar & grm) : gram(grm), pchart(NULL), caches() {}

  void parse(uchart & chart, bool surf = false);

  /*
  void parse(const sentence_fsa & text, int & begin, int & end);
  void parse(const sentence_fsa & text);
  */


protected:

  void travel(const std::string & fstname, details::cache_fst & cache, int q, std::vector<syntref> & path,
              const featstruct & currfs, double w);

  int inter_state(int q1, const usyntagm_pattern & fst, int q2, details::cache_fst & cache);


  void parse(int q1, int syntno);
  void parse(int q1, const std::string & syntname);

protected:
  const ugrammar & gram;
  uchart  * pchart;

  std::vector<details::cache_fst> caches;
};

#endif

