#ifndef _UGRAMMAR_H_
#define _UGRAMMAR_H_

#include <string>

#include <boost/filesystem/path.hpp>

#include <outilex/xml.h>
#include <outilex/usyntagm_pattern.h>

class ling_def;


class ugrammar {

public:

  typedef usyntagm_pattern::input_type input_type;
  typedef usyntagm_pattern::output_type output_type;

  ugrammar(ling_def * ldef) : lingdef(ldef), syntagms(), synt_map(), start_graph(0) {}
  ugrammar(const boost::filesystem::path & path, ling_def * lingdef);

  int start() const { return start_graph; }
  const std::string & start_name() const { return syntagms[start()].get_name(); }

  int size() const { return syntagms.size(); }

  int get_syntagm_idx(const std::string & name) const {
    std::map<std::string, int>::const_iterator it = synt_map.find(name);
    if (it == synt_map.end()) { return -1; }
    return it->second;
  }

  const usyntagm_pattern & operator[](int no) const { return syntagms[no]; }
  usyntagm_pattern & operator[](int no) { return syntagms[no]; }

  int add_pattern(const usyntagm_pattern & pattern);
  int add_pattern(const boost::filesystem::path & path, const std::string & name);

  void write(const boost::filesystem::path & path) const;
  void write_XML(xmlwriter & writer) const;

  void read(const boost::filesystem::path & path);
  void read_XML(xmlNodePtr node);

protected:
  ling_def * lingdef;
  std::vector<usyntagm_pattern> syntagms;
  std::map<std::string, int> synt_map;
  int start_graph;
};

#endif
