#ifndef _SYNT_INPUT_TYPE_H_
#define _SYNT_INPUT_TYPE_H_

#include <string>
#include <boost/variant.hpp>

#include <outilex/xml.h>
#include <outilex/lexical_mask.h>


struct synt_input_type {

  enum noname { EPSILON, LEXMASK, SUBCALL } type;
  boost::variant<std::string, lexical_mask> v;

  synt_input_type() : type(LEXMASK), v(std::string()) {}

  /* construct from a text description */
  synt_input_type(const std::string & text, ling_def * ldef);

  void write_xml(xmlwriter & writer) const;
  void read_xml(xmlNodePtr node, ling_def * lingdef);
};

#endif
