#ifndef _EARLEY2_PARSER_H_
#define _EARLEY2_PARSER_H_

#include <vector>
#include <set>
#include <list>

#include <outilex/compare_by_idx.h>
#include <outilex/ugrammar.h>
#include <outilex/uchart.h>
#include <outilex/uparser.h>


#if 0
template<typename RandomAccessContainer>
struct compare_by_idx {

  typedef RandomAccessContainer container_type;

  compare_by_idx(const container_type & C_) : pC(& C_) {
    //std::cerr << "compare_by_idx(& C = " << pC << ")\n";
  }

  bool operator()(int a, int b) const {
    return (*pC)[a] < (*pC)[b];
  }

  const container_type * pC; 
};
#endif

class earley2_parser : public uparser {

public:

  typedef ugrammar::input_type  input_type;
  typedef ugrammar::output_type output_type;


  earley2_parser(const ugrammar & grm) : gram(grm), pchart(NULL), agenda() {}
  ~earley2_parser() {}


  void parse(uchart & chart, bool surf = false);


public:

  /* internal data structures */

  struct e_item {

    const usyntagm_pattern * pfst;
    int q;
    int from, to;
    std::vector<featstruct> fs;
    synt_path_type path;

    e_item(const usyntagm_pattern & fst_, int q_, int from_, int to_,
           const featstruct & fs_, const synt_path_type & path_)
      : pfst(& fst_), q(q_), from(from_), to(to_), fs(), path(path_) { fs.push_back(fs_); }

    e_item(const usyntagm_pattern & fst_, int q_, int from_, int to_,
           const std::vector<featstruct> & fs_, const synt_path_type & path_)
      : pfst(& fst_), q(q_), from(from_), to(to_), fs(fs_), path(path_) {}

    e_item(const usyntagm_pattern & fst_, int q_, int from_, int to_,
           const std::list<featstruct> & fs_, const synt_path_type & path_)
      : pfst(& fst_), q(q_), from(from_), to(to_), fs(fs_.begin(), fs_.end()), path(path_) {}


    bool operator<(const e_item & item) const {
      if (pfst != item.pfst) { return pfst < item.pfst; }
      if (q != item.q) { return q < item.q; }
      if (from != item.from) { return from < item.from; }
      if (to != item.to) { return to < item.to; }
      return path < item.path;
    }

    void dump(std::ostream & os) const;
  };


  struct earley_stack {

    earley_stack() : items(), item_set(comparaison_type(items)) {}

    earley_stack(const earley_stack & s) 
      : items(s.items), item_set(s.item_set.begin(), s.item_set.end(), comparaison_type(items)) {
        //std::cerr << "earley_stack:: copy constructor\n";
      }

    typedef std::vector<e_item>::iterator iterator;
    typedef std::vector<e_item>::const_iterator const_iterator;

    typedef compare_by_idx<std::vector<e_item> > comparaison_type;
    //typedef std::multiset<int, compare_by_idx<std::vector<e_item> > > item_set_type;
    typedef std::set<int, compare_by_idx<std::vector<e_item> > > item_set_type;

    typedef item_set_type::iterator by_val_iterator;
    typedef item_set_type::const_iterator const_by_val_iterator;


    inline int size() const { return items.size(); }

    void push_back(const e_item & item);


    inline e_item & operator[](int idx) { return items[idx]; }
    inline const e_item & operator[](int idx) const { return items[idx]; }

    iterator begin() { return items.begin(); }
    const_iterator begin() const { return items.begin(); }

    iterator end() { return items.end(); }
    const_iterator end() const { return items.end(); }

    by_val_iterator by_val_begin() { return item_set.begin(); }
    by_val_iterator by_val_end() { return item_set.end(); }

    by_val_iterator lower_bound(const e_item & it) const {
      int idx = items.size();
      std::vector<e_item> & itms = const_cast<std::vector<e_item> &>(items);
      itms.push_back(it);  
      const_by_val_iterator res = item_set.lower_bound(idx);
      itms.pop_back();
      return res;
    }


    std::vector<e_item> items;
    item_set_type item_set;
    //std::set<int, compare_by_idx<std::vector<e_item> > item_set;
  };

  typedef std::vector<earley_stack> e_agenda;

  const ugrammar & gram;
  uchart * pchart;
  e_agenda agenda;

protected:

  void ENQUEUE(int pos, const e_item & item);
  void PREDICTOR(int pos, const std::string & syntname);
  void COMPLETER(int pos, const e_item & item);
};

inline std::ostream & operator<<(std::ostream & os, const earley2_parser::e_item & item) {
  item.dump(os); return os;
}
#endif
