#ifndef _DETAILS_CACHE_FST_
#define _DETAILS_CACHE_FST_

#include <outilex/wgb_color.h>
#include <outilex/usyntagm_pattern.h>

namespace details {

struct cache_fst {

public:

  typedef int input_type;
  typedef usyntagm_pattern::output_type output_type;

  typedef std::set<output_type> outputs_type;

  typedef std::map<std::pair<int, int>, int> states_map;

  struct transition {
    
    int to_;
    input_type in_;
    output_type out_;
    
    transition(const input_type & input, const output_type & output, int dest) : to_(dest), in_(input), out_(output) {}
 
    int to() const { return to_; }
    const input_type & in()   const { return in_; }
    const output_type & out() const { return out_; }
  };

  typedef std::vector<transition> transitions;
  typedef transitions::iterator trans_iterator;

  struct state {

    wgb_color color;
    int state_in_text;
 
    bool final;
    bool useful;
    outputs_type final_outputs;

    transitions trans;

    state() : color(white), state_in_text(-1), final(false), useful(false), final_outputs(), trans() {}
  };


  std::vector<state> states;
  states_map state_ids;

  std::vector<bool>  done;
  std::vector<std::pair<int, int> > result;

  cache_fst() : states(), state_ids(), done(), result() {}

  inline void init(int fsa_size) { done.resize(fsa_size, false); result.resize(fsa_size); }

  inline int size() const { return states.size(); }

  inline state & operator[](int q) { return states[q]; }

  int find_state(int q1, int q2) const;
  int add_state(int q1, int q2);

  bool & final(int q) { return states[q].final; }
  bool final(int q) const { return states[q].final; }
  void set_final(int q, bool v = true) { states[q].final = v; }

  bool & useful(int q) { return states[q].final; }
  bool useful(int q) const { return states[q].final; }

  wgb_color & color(int q) { return states[q].color; }
  const wgb_color & color(int q) const { return states[q].color; }

  inline int state_in_text(int q) const { return states[q].state_in_text; }

  inline outputs_type & final_outputs(int q) { return states[q].final_outputs; } 
  inline void add_final_output(int q, const output_type & output) {
    states[q].final_outputs.insert(states[q].final_outputs.begin(), output);
  }

  inline void add_final_outputs(int q, const outputs_type & outputs) {
    states[q].final_outputs.insert(outputs.begin(), outputs.end());
  }

  inline trans_iterator trans_begin(int q) { return states[q].trans.begin(); }
  inline trans_iterator trans_end(int q) { return states[q].trans.end(); }


  inline void add_trans(int q, const input_type & in, const output_type & out, int to) {
    states[q].trans.push_back(transition(in, out, to));
  }
};

} // namespace detail cache_fst

#endif
