#include <boost/filesystem/path.hpp>
#include <outilex/fsa_text_uchart.h>
#include <outilex/text_fsa.h>
#include <outilex/sentence_fsa.h>
#include <outilex/uchart.h>


namespace fs = boost::filesystem;


int LINK_WITH_FSA_TEXT_UCHART;

namespace {

itext_uchart * new_fsa_itext_uchart(const fs::path & path, ling_def * ldef) {
  return new fsa_itext_uchart(path, ldef);
}

text_chart_reader_registerer ifsa_registerer(is_text_fsa, new_fsa_itext_uchart);

} // namespace ""


fsa_itext_uchart::fsa_itext_uchart(const fs::path & path, ling_def * ldef) 
  : itext(new_itext_fsa(path, ldef)) {}

int fsa_itext_uchart::size() const {  return itext->size(); }

bool fsa_itext_uchart::ok() const { return itext->ok(); }

bool fsa_itext_uchart::read_next(uchart & chart) {
  sentence_fsa fsa;
  if (! itext->read_next(fsa)) { return false; }
  chart.eat(fsa);
  return true;
}

bool fsa_itext_uchart::seek(int pos) { return itext->seek(pos); }
void fsa_itext_uchart::rewind() { return itext->rewind(); }

int fsa_itext_uchart::tell() const { return itext->tell(); }


