#include <boost/lexical_cast.hpp>
#include <outilex/fs_node.h>

using namespace std;
using namespace boost;

const fs_node * follow(const fs_node * n) {
  if (! n) { return NULL; }
  while (n->type == FS_REF) {
    n += n->offset;
  }
  return n;
}

fs_node * follow(fs_node * n) {
  if (! n) { return NULL; }
  while (n->type == FS_REF) {
    n += n->offset;
  }
  return n;
}


const fs_node * find_attr(const fs_node * n, const std::string & attrname) {
 
  if (n->type == FS_FS) { n += n->next; }

  while (n->type == FS_ATTR && n->str < attrname) {
    n += n->next;
  }
  if (n->type == FS_ATTR && n->str == attrname) { return n; }
  return 0;
}

void clear_tags(const fs_node * n) {

  vector<const fs_node *> stack;
  stack.push_back(n);

  while (! stack.empty()) {
    
    n = follow(stack.back()); stack.pop_back();
 
    if (! n || n->offset == 0) { continue; }
    n->offset = 0;

    if (n->type == FS_FS) {
    
      const fs_node * attr = n + n->next;
      while (attr != n) {
        stack.push_back(attr + attr->offset);
        attr += attr->next;
      }
    
    } else if (n->type == FS_SET) {
      
      const fs_node * elem = n + n->next;
      while (elem != n) {
        stack.push_back(elem + elem->offset);
        elem += elem->next;
      }
    }
  }
}


bool is_unset(const fs_node * n) {

  n = follow(n);

  if (n->type == FS_UNSET) { return true; }

  if (n->type == FS_FS) {
    const fs_node * attr = n + n->next;
    while (attr != n) {
      if (! is_unset(attr + attr->offset)) { return false; }
      attr += attr->next;
    }
    return true;
  
  } else if (n->type == FS_SET) {
  
    const fs_node * elem = n + n->next;
    while (elem != n) {
      if (! is_unset(elem + elem->offset)) { return false; }
      elem += elem->next;
    }
    return true;
  }

  // sinon c'est faux
  return false;
}


#if 0
bool equal(const fs_node * n1, const fs_node * n2, int * tag1, int * tag2) {

  n1 = follow(n1); n2 = follow(n2);

  if (n1 == n2) { return true; }

  if (! n1 || ! n2) { return false; }

  if (*tag1 || *tag2) { // reentrancy check
    return *tag1 == -*tag2;
  }

  if (n1->type != n2->type) { return false; }

  *tag1 = n2 - n1;
  *tag2 = n1 - n2;

  switch (n1->type) {

  case FS_UNSET:
    break;

  case FS_STRING:
    return (n1->str == n2->str);
    break;

  case FS_VAL:
    return (n1->feat == n2->feat);
    break;

  case FS_FS: {

    tag1 += n1->next, tag2 += n2->next;
    const fs_node * attr1 = n1 + n1->next, * attr2 = n2 + n2->next;

    while (1) {
      
      if (attr1 == n1) { return (attr2 == n2); }
      if (attr2 == n2 || attr1->str != attr2->str) { return false; }

      if (! equal(attr1 + attr1->offset, attr2 + attr2->offset,
                  tag1 + attr1->offset, tag2 + attr2->offset)) {
        return false;
      }
      tag1 += attr1->next, tag2 += attr2->next;
      attr1 += attr1->next, attr2 += attr2->next;
    }
  }
    break;
  }

  return true;
}
#endif


bool equal(const fs_node * N1, const fs_node * N2, int * T1, int * T2) {

  vector<const fs_node *> stack;

  stack.push_back(N1);
  stack.push_back(N2);

  const fs_node * n1, * n2;
  int * tag1, * tag2;

  while (! stack.empty()) {

    n2 = follow(stack.back()); stack.pop_back();
    tag2 = T2 + (n2 - N2);

    n1 = follow(stack.back()); stack.pop_back();
    tag1 = T1 + (n1 - N1);
 
    if (n1 == n2) { continue; } 

    if (! n1 || ! n2) { return false; }

    if (n1->type != n2->type) { return false; }
  
    if (*tag1 || *tag2) { // reentrancy check
      if (*tag1 != -*tag2) { return false; }
      continue;
    }

    *tag1 = n2 - n1;
    *tag2 = n1 - n2;

    switch (n1->type) {

    case FS_UNSET:
    case FS_EXIST:
    case FS_NOEXIST:
      break;

    case FS_CONSTR:
    case FS_STRING:
      if (n1->str != n2->str) { return false; };
      break;

    case FS_VAL:
      if (n1->feat != n2->feat) { return false; }
      break;

    case FS_FS: {

      const fs_node * attr1 = n1 + n1->next, * attr2 = n2 + n2->next;

      while (attr1 != n1 && attr2 != n2) {

        if (attr1->str != attr2->str) { return false; }

        stack.push_back(attr1 + attr1->offset);
        stack.push_back(attr2 + attr2->offset);

        attr1 += attr1->next, attr2 += attr2->next;
      }
      if (attr1 != n1 || attr2 != n2) { return false; }
    }
      break;

    case FS_SET: {

      const fs_node * elem1 = n1 + n1->next, * elem2 = n2 + n2->next;

#warning "equal: set are assumed ordered ..."
      while (elem1 != n1 && elem2 != n2) {

        stack.push_back(elem1 + elem1->offset);
        stack.push_back(elem2 + elem2->offset);

        elem1 += elem1->next; elem2 += elem2->next;
      }
      if (elem1 != n1 || elem2 != n2) { // cardinals differ
        return false;
      }
    }
      break;

    default:
      throw logic_error("equal: invalid featnode: type = " + lexical_cast<string>(n1->type));
    }
  }

  return true;
}



// equal 2 is slower than equal
// because of clear_tags ...

namespace {

bool equal2_impl(const fs_node * n1, const fs_node * n2) {

  vector<const fs_node *> stack;

  stack.push_back(n1);
  stack.push_back(n2);

  while (! stack.empty()) {

    n2 = follow(stack.back()); stack.pop_back();

    n1 = follow(stack.back()); stack.pop_back();
 
    if (n1 == n2) { continue; } 

    if (! n1 || ! n2) { return false; }

    if (n1->type != n2->type) { return false; }
  
    if (n1->offset || n2->offset) { // reentrancy check
      if (n1->offset != -n2->offset) { return false; }
      continue;
    }

    n1->offset = n2 - n1;
    n2->offset = n1 - n2;

    switch (n1->type) {

    case FS_UNSET:
      break;

    case FS_STRING:
      if (n1->str != n2->str) { return false; };
      break;

    case FS_VAL:
      if (n1->feat != n2->feat) { return false; }
      break;

    case FS_FS: {

      const fs_node * attr1 = n1 + n1->next, * attr2 = n2 + n2->next;

      while (attr1 != n1 && attr2 != n2) {

        if (attr1->str != attr2->str) { return false; }

        stack.push_back(attr1 + attr1->offset);
        stack.push_back(attr2 + attr2->offset);

        attr1 += attr1->next, attr2 += attr2->next;
      }
      if (attr1 != n1 || attr2 != n2) { return false; }
    }
      break;

#warning "equal: SET are considered ordered"
    case FS_SET: {
    
      const fs_node * elem1 = n1 + n1->next, * elem2 = n2 + n2->next;

      while (elem1 != n1 && elem2 != n2) {
      
        stack.push_back(elem1 + elem1->offset);
        stack.push_back(elem2 + elem2->offset);

        elem1 += elem1->next; elem2 += elem2->next;
      }
      if (elem1 != n1 || elem2 != n2) { return false; }
    }
      break;

    default:
      throw logic_error("equal: invalid featnode: type = " + lexical_cast<string>(n1->type));
    }
  }

  return true;
}

} //namespace ""


bool equal2(const fs_node * n1, const fs_node * n2) {
  bool res = equal2_impl(n1, n2);
  clear_tags(n1); clear_tags(n2);
  return res;
}

