#include <iostream>
#include <set>
#include <vector>

#include <outilex/sentence_fsa.h>
#include <outilex/ugrammar.h>
#include <outilex/uchart.h>
#include <outilex/unification.h>
#include <outilex/earley2_parser.h>


using namespace std;
using namespace boost;

/*
typedef boost::multi_index_container<
  e_item,
  indexed_by<
    sequenced<tag<by_pos> >,
    ordered_unique<tag<by_val>, identity<e_item> >
  >
> earley_stack;
*/

namespace {
void check_item_path(const earley2_parser::e_item & item, const uchart & chart) {
  const synt_path_type & path = item.path;
  for (synt_path_type::const_iterator it = path.begin(); it != path.end(); ++it) {
    int q = it->qno, transno = it->transno;
    if (q < 0 || q > chart.size()) {
      cerr << "bad item : " << item << endl;
      throw logic_error("internal earley error");
    }
    
    if (transno < 0) {
      transno = -transno - 1;
      if (transno > chart[q].size()) {
        cerr << "bad item: " << item << ": synttransno out of bound\n";
        throw logic_error("internal earley error");
      }
    } else {
      if (transno > chart.fsa.trans_size(q)) {
        cerr << "bad item: " << item << ": lextransno out of bound\n";
        throw logic_error("internal earley error");
      }
    }
  }
}

bool seems_like(const earley2_parser::e_item & i1, const earley2_parser::e_item & i2) {
  return i1.pfst == i2.pfst && i1.q == i2.q && i1.from == i2.from && i1.to == i2.to && i1.path == i2.path;
}

} // anonymous namespace





void earley2_parser::earley_stack::push_back(const e_item & item) {

/*
  cerr << "stack push_back: " << item << "\n";
  cerr << "fs size = " << item.fs.size() << '\n';

  cerr << "fs = \n";
  copy(item.fs.begin(), item.fs.end(), ostream_iterator<featstruct>(cerr, "\n"));
*/

  int idx = items.size();
  items.push_back(item);
  std::pair<item_set_type::iterator, bool> res = item_set.insert(idx);

  if (! res.second) { // already present, add new featstructs

    items.pop_back();

    e_item & item2 = items[*res.first];
    int fs2size = item2.fs.size();

    /*
    cerr << "already here\n";
    cerr << "fs (size = " << fs2size << " = \n";
    copy(item.fs.begin(), item.fs.end(), ostream_iterator<featstruct>(cerr, "\n"));
    */

    for (vector<featstruct>::const_iterator fs1 = item.fs.begin(); fs1 != item.fs.end(); ++fs1) {
      int i = 0;
      for (i = 0; i < fs2size; ++i) {
        if (*fs1 == item2.fs[i]) { 
          break;
        } //else { cerr << "not equal\n"; }
      }
      if (i == fs2size) { item2.fs.push_back(*fs1); }
    }
  }

/*
  e_item & i = items[*res.first];
  if (i.fs.size() != 1)
    cerr << "out of push_back: fs size = " << i.fs.size() << endl;
*/
}

void earley2_parser::e_item::dump(ostream & os) const {
  os << "{ (" << pfst->get_name() << ", " << q << "), [" << from << ", " << to << "], " << path  << "}";
}


void earley2_parser::ENQUEUE(int pos, const e_item & item) {

//  cerr << "ENQUEUE(" << pos << ", " << item  << ")\n";

  earley_stack & s = agenda[pos];

  earley_stack::comparaison_type compare = s.item_set.key_comp();
  assert(& s.items == compare.pC);
 
  // all the magy is in push_back now
  agenda[pos].push_back(item);
//  cerr << "out of ENQUEUE\n";
}


void earley2_parser::parse(uchart & chart, bool surf) {

  //cerr << "earley parse\n";
 
  /* initialization stuffs */

  pchart = & chart;
  const sentence_fsa & txt = chart.fsa;
  
  agenda.clear();
  agenda.resize(txt.size());

  if (surf) {
    const string & axiom = gram.start_name();
    for (int pos = 0; pos < txt.size(); ++pos) {
      PREDICTOR(pos, axiom);
    }
  } else {
    PREDICTOR(0, gram.start_name());
  }

  for (int pos = 0; pos < txt.size(); ++pos) {

   //cerr << "POS = " << pos << endl;

    earley_stack & stack = agenda[pos];

    for (int i = 0; i < stack.size(); ++i) {
    
      //cerr << "\n" << pos << ":item #" << i << ": " << stack[i] << endl;
      //check_item(stack[i], chart);

      const usyntagm_pattern & fst = *(stack[i].pfst);
      int q = stack[i].q;


      if (q == -1) { // TERMINAL
        //cerr << "FAKE terminal\n";
        COMPLETER(pos, stack[i]);
        continue;
      }

      if (fst.final(q)) { // item is completed, add a completed itm (q == -1)
        //cerr << "COMPLETE, create a FAKE terminal item\n";
        const e_item & item = stack[i];
        ENQUEUE(pos, e_item(fst, -1, item.from, item.to, item.fs, item.path));
      } 


      for (usyntagm_pattern::const_trans_iterator str = fst.trans_begin(q);
           str != fst.trans_end(q); ++str) {

        if (str->in().type == input_type::SUBCALL) {

          const string & syntname = boost::get<string>(str->in().v);
 
          //cerr << "-> SUBCALL: " << syntname << endl;

          PREDICTOR(pos, syntname);
 
        } else if (str->in().type == input_type::LEXMASK) {

          const lexical_mask & m = boost::get<lexical_mask>(str->in().v);

          //cerr << "-> LEX: " << m << endl;

          for (int transno = 0; transno < txt.trans_size(pos); ++transno) {
 
            const sentence_fsa::transition tr = txt.get_trans(pos, transno); 
            const lexical_mask & e = tr.in();

            if (e.intersect(m)) {

              //cerr << tr.in() << " match with " << m << endl;

              const e_item & item = stack[i];

              synt_path_type npath(item.path);
              npath.push_back(syntref(pos, transno));

              if (! str->out().constraints.empty()) {

                //featstruct fs(item.fs);
                //fs.set("$$", tr.in());

                list<featstruct> fs(item.fs.begin(), item.fs.end());

                if (check_constraints(str->out().constraints, fs, tr.in())) {
                  ENQUEUE(tr.to(), e_item(fst, str->to(), item.from, tr.to(), fs, npath));
                }

              } else {

                ENQUEUE(tr.to(), e_item(fst, str->to(), item.from, tr.to(), item.fs, npath));
              }
            }
          }

        } else {

          //cerr << "-> EPSILON\n";
 
          const e_item & item = stack[i];

          if (! str->out().constraints.empty()) {

            list<featstruct> fs(item.fs.begin(), item.fs.end());

            if (check_constraints(str->out().constraints, fs)) {
              ENQUEUE(pos, e_item(fst, str->to(), item.from, item.to, fs, item.path));
            }

          } else {
            ENQUEUE(pos, e_item(fst, str->to(), item.from, item.to, item.fs, item.path));
          }
        }
      }
    }
    //cerr << "done with POS " << pos << " stack size = " << stack.size() << "\n\n";
  }
  //cerr << "out of early-parse\n";
}


void earley2_parser::PREDICTOR(int pos, const std::string & syntname) {

  //cerr << "entering PREDICTOR(" << syntname << ")\n";

  int syntno = gram.get_syntagm_idx(syntname);
  //cerr << "syntno  = " << syntno << endl;

  if (syntno == -1) {
    cerr << "warning: unknow syntagm: " << syntname << endl;
    return;
  }
  featstruct fs;
  fs.set("CAT", syntname);
  ENQUEUE(pos, e_item(gram[syntno], 0, pos, pos, fs, synt_path_type()));
}



void earley2_parser::COMPLETER(int pos, const e_item & item1) {

  uchart & chart = *pchart;

  const string & syntname = item1.pfst->get_name();

#warning "i lost weight!"

  cerr << "\n\nCOMPLETER(" << syntname << ")\n";

  //check_item(item1, chart);

  if (item1.from == item1.to) {
    cerr << "error: synt desc: " << syntname << " matches empty word\n";
    return;
  }

  cerr << "item = " << item1 << endl;

  vector<int> synt_idxs;
  for (vector<featstruct>::const_iterator it = item1.fs.begin(); it != item1.fs.end(); ++it) {
    cerr << "fs = " << *it << endl;
    synt_idxs.push_back(chart.add_match(item1.from, syntagm(syntname, item1.to, *it, item1.path, 1.)));
  }
  
  cerr << "COMPLETER: " << syntname << " : " << synt_idxs.size() << " syntagms added\n";

  int curr = item1.to;
  earley_stack & stack = agenda[item1.from];

  // warning: do not use item1 ref in the following block,
  // because its adress can change .... (call to ENQUEUE)
  for (earley_stack::iterator it = stack.begin(); it != stack.end(); ++it) {
  
  //  cerr << "next item\n";
    const e_item & item2 = *it;
    const usyntagm_pattern & fst = *item2.pfst;
    const vector<featstruct> & curfs = item2.fs;
    int q = item2.q;

    if (q == -1) { continue; }

    for (usyntagm_pattern::const_trans_iterator str = fst.trans_begin(q);
         str != fst.trans_end(q); ++str) {

      if (str->in().type == input_type::SUBCALL
          && boost::get<string>(str->in().v) == syntname) {

        //cerr << "find something\n";

        for (vector<int>::const_iterator idx = synt_idxs.begin(); idx != synt_idxs.end(); ++idx) {

          //cerr << "idx = " << *idx << endl;

          synt_path_type npath(item2.path);
          npath.push_back(syntref(item2.to, - *idx - 1));
          //cerr << "path = " << npath << endl;

          if (! str->out().constraints.empty()) {

            //cerr << "unification stuffs\n";
            const featstruct & matchfs = chart.get_synt(item2.to, *idx).fs; //item2.to == item1.from

            list<featstruct> fs(curfs.begin(), curfs.end());
            //cerr << "before check_constraints fs size = " << fs.size() << "matchfs = " << matchfs << "\n";
            //cerr << "feat to check : " << endl;
            //copy(fs.begin(), fs.end(), ostream_iterator<featstruct>(cerr, "\n"));

            if (check_constraints(str->out().constraints, fs, matchfs)) {
              //cerr << "unif ok\n";
              ENQUEUE(curr, e_item(fst, str->to(), item2.from, curr, fs, npath));
            }
            //cerr << "out of unif stuffs\n";

          } else {
            //cerr << "no constraints\n";
            ENQUEUE(curr, e_item(fst, str->to(), item2.from, curr, curfs, npath));
          }
          //cerr << "done with idx = " << *idx << endl;
        }
        //cerr << "done with something\n";
      }
    }
  }
  //cerr << "out of COMPLETER\n";
}

