#include <iostream>
#include <boost/filesystem/path.hpp>
#include <outilex/string_transducer.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/xml_format_lexmask.h>
#include <outilex/xml_format_fst.h>

using namespace std;
namespace fs = boost::filesystem;
using namespace xmlnames;

struct string_fst_xml_formater {

  ling_def * ldef;

  string_fst_xml_formater(ling_def * l) : ldef(l) {}

  const char * fst_name() { return xmlnames::STRING_FST_ELEM; }
  
  void read_fst_data(xmlNode * n, string_transducer & T) {}
  void write_fst_data(xmlwriter & writer, const string_transducer & T) {}

  void read_fst_state_data(xmlNode * n, string_transducer & T, int q) {}
  void write_fst_state_data(xmlwriter & writer, const string_transducer & T, int q) {}

  void read_in(xmlNode * node, lexical_mask & in) {
    node = node->children;
    while (node) {
      if (xmlStrcmp(node->name, LEXMASK_ELEM) == 0) {
        lexmask_read_xml(node, in, ldef);
        return;
      }
      //cerr << "nodename = " << node->name << endl;
      node = node->next;
    }
    cerr << "stringfst::read_in: no lexmask found?\n";
    in.clear();
  }

  void write_in(xmlwriter & writer, const lexical_mask & in) {
    lexmask_write_xml(writer, in);
  }


  void read_out(xmlNode * node, string_output & out) {
    node = node->children;
    while (node) {
      if (xmlStrcmp(node->name, xmlnames::STRING_OUTPUT_ELEM) == 0) {
        out.read_xml(node);
        return;
      }
      node = node->next;
    }
  }

  void write_out(xmlwriter & writer, const string_output & out) {
    out.write_xml(writer);
  }

};

string_transducer::string_transducer(const fs::path & path, ling_def * ldef)
  : fst_type(), lingdef(ldef) {

  xml_read_fst(path, *this, string_fst_xml_formater(ldef));
  check_for_final_outputs();
}

void string_transducer::write(const fs::path & path) const {
  xml_write_fst(path, *this, string_fst_xml_formater(lingdef));
}

