#include <string>
#include <boost/lexical_cast.hpp>
#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/string_output.h>

using namespace std;
using namespace boost;
using namespace xmlnames;


#if 0
void string_output::elem::write_xml(xmlwriter & writer) const {
  writer.start_element(ELEM_ELEM);
  writer.write_attribute(VAL_ATTR, v);
  writer.write_attribute(POS_ATTR, lexical_cast<string>(pos));
  writer.end_element();
}


void string_output::elem::read_xml(xmlNodePtr node) {
  v = xmlGetConstProp(node, VAL_ATTR);
  pos = lexical_cast<int>(xmlGetConstProp(node, POS_ATTR));
}
#endif


void string_output::write_xml(xmlwriter & writer) const {

  writer.start_element(xmlnames::STRING_OUTPUT_ELEM);

  if (inf) {
    writer.write_element(xmlnames::INF_ELEM);
  } else {
    for (map<int, string>::const_iterator it = v.begin(), end = v.end();
         it != end; ++it) {
      writer.start_element(ELEM_ELEM);
      writer.write_attribute(VAL_ATTR, it->second);
      writer.write_attribute(POS_ATTR, lexical_cast<string>(it->first));
      writer.end_element();
    }
  }
  writer.end_element();
}


void string_output::read_xml(xmlNode * node) {

  inf = false;
  v.clear();

  node = node->xmlChildrenNode;
  while (node) {
 
    if (xmlStrcmp(node->name, xmlnames::ELEM_ELEM) == 0) {

      v[lexical_cast<int>(xmlGetConstProp(node, POS_ATTR))] = xmlGetConstProp(node, VAL_ATTR);

    } else if (xmlStrcmp(node->name, xmlnames::INF_ELEM) == 0) {
      inf = true;
      v.clear();
      return;
    }
    node = node->next;
  }
}

