#include <iostream>

#include <outilex/string_transducer.h>
#include <outilex/generic_fst.h>


using namespace std;


string_transducer::string_transducer(const generic_fst & fst, ling_def * ldef)
  : fst_type(), lingdef(ldef) {

  int size = fst.size();
  clear();
  resize(size);

  for (int i = 0; i < size; ++i) {

    set_final(i, fst.final(i));

    if (final(i)) {
      generic_fst::outputs_type::const_iterator it, end;
      for (it = fst.final_outputs_begin(i), end = fst.final_outputs_end(i);
           it != end; ++it) {
        final_outputs(i).insert(output_type(*it));
      }
    }

    for (generic_fst::transitions::const_iterator tr = fst.trans_begin(i), end = fst.trans_end(i);
         tr != end; ++tr) {
      add_trans(i, input_type(tr->in(), lingdef), output_type(tr->out()), tr->to());
    }
  }

  check_for_final_outputs();
}



void string_transducer::check_for_final_outputs() {
  for (int q = 0; q < size(); ++q) {
    if (final(q) && final_outputs(q).empty()) {
      cerr << "error final state without final outputs?\n";
      final_outputs(q).insert(output_type::one());
    }
  }
}

