#include <iostream>
#include <cassert>
#include <iterator>
#include <vector>

#include <outilex/string_output.h>


using namespace std;




/* string concatenation : union */

string_output string_output::mult(const string_output & a, const string_output & b) {
  string_output res(a);
  res *= b;
  return res;
}


string_output & string_output::operator*=(const string_output & b) {

  if (inf) { return *this; }

  if (b.inf) {
    inf = true; v.clear();
  } else {
    for (map<int, string>::const_iterator it = b.v.begin(), end = b.v.end();
         it != end; ++it) {
      v[it->first].append(" " + it->second);
    }
  }
  return *this;
}


/* string prefixation : intersection */

string_output string_output::plus(const string_output & a, const string_output & b) {

  if (a.inf) { return b; }
  if (b.inf) { return a; }

  string_output res(false);
  set_intersection(a.v.begin(), a.v.end(), b.v.begin(), b.v.end(), inserter(res.v, res.v.begin()));
  return res;
}


string_output string_output::minus(const string_output & a, const string_output & b) {
//  cerr << "string_output: minus:" << a << " minus " << b << " = ";
  assert(includes(a.v.begin(), a.v.end(), b.v.begin(), b.v.end()));
  string_output res(false);
  set_difference(a.v.begin(), a.v.end(), b.v.begin(), b.v.end(), inserter(res.v, res.v.begin()));
//  cerr << res << endl;
  return res;
}

string_output string_output::delay(int del) const {

  if (inf) { return string_output(true); }

  string_output res(false);

  for (map<int, string>::const_iterator it = v.begin(), end = v.end();
       it != end; ++it) {
    res.v[it->first + del] = it->second;
  }
  return res;
}

void string_output::set_delay(int del) {

  if (inf) { return; }

  map<int, string> nv;
  for (map<int, string>::const_iterator it = v.begin(), end = v.end();
       it != end; ++it) {
    nv[it->first + del] = it->second;
  }
  v.swap(nv);
}


void string_output::read_text(const std::string & text) {
  inf = false;
  v.clear();
  if (! text.empty()) { v[0] = text; }
}


void string_output::dump_text(ostream & os) const {
  if (inf) { os << "<inf>"; return; }
  if (v.empty()) { os << "<one>"; }
  for (map<int,string>::const_iterator it = v.begin(), end = v.end();
       it != v.end(); ++it) {
    os << "(" << it->first << ", " << it->second << ")";
  }
}


