#ifndef _TRANSDUCTION4_H_
#define _TRANSDUCTION4_H_

#include <iosfwd>
#include <outilex/string_transducer.h>
#include <outilex/deter_pred_fst2.h>

class sentence_fsa;

struct my_semiring_ops {

  static inline string_output mult(const string_output & a, const string_output & b) {
    return string_output::mult(a, b);
  }

  static inline string_output plus(const string_output & a, const string_output & b) {
    return string_output::plus(a, b);
  }

  static inline string_output minus(const string_output & a, const string_output & b) {
    return string_output::minus(a, b);
  }

  static inline string_output zero() { return string_output(true); }
  static inline string_output one() { return string_output(false); }
};

class my_deter_string_fst 
  : public deter_pred_fst2<string_transducer, my_semiring_ops> {
};

enum {
  MERGE_MODE,   // merge output with input
  REPLACE_MODE, // replace matching sequences with output
  IGNORE_MODE   // ignore transduction outputs
};

enum {
  TEXT_OUTPUT,  // output result as raw text
  HTML_OUTPUT   // output result in HTML format
};

int transduction4(sentence_fsa & text, my_deter_string_fst & T, std::ostream & os, 
                  int transmode, int outputmode);

#endif
