#ifndef _STRING_TRANSDUCER_H_
#define _STRING_TRANSDUCER_H_

#include <outilex/basic_fst.h>

#include <outilex/lexical_mask.h>
#include <outilex/string_output.h>

class lexical_entry;
class generic_fst;
class ling_def;


class string_transducer : public basic_fst<lexical_mask, string_output> {

public:

  typedef basic_fst<lexical_mask, string_output> fst_type;
  typedef lexical_mask elem_input_type;

  string_transducer(ling_def * ldef = NULL) : fst_type(), lingdef(ldef) {}
  
  string_transducer(const generic_fst & fst, ling_def * ldef);

  string_transducer(const boost::filesystem::path & path, ling_def * ldef);

  void write(const boost::filesystem::path & path) const;

  ling_def * get_lingdef() const { return lingdef; }

  void check_for_final_outputs();

protected:

  ling_def * lingdef;
};

#endif
