#ifndef _STRING_OUTPUT_H_
#define _STRING_OUTPUT_H_

#include <iostream>
#include <string>
#include <map>

#include <outilex/xml.h>


struct string_output {

#if 0
  struct elem {

    int pos; 
    std::string v;

    inline elem(xmlNodePtr node) : pos(0), v() { read_xml(node); }

    inline elem(const std::string & _v) : pos(0), v(_v) {}
 
    /* delay the output to keep position with the corresponding
     * input trans in the matching sequence
     */
    inline elem delay(int del = 1) const { return elem(v, pos + del); }
 
    // inline void operator++() { if (pos >= 0) { pos++; } }

    inline bool operator<(const elem & b) const {
      if (pos != b.pos) { return pos < b.pos; }
      return v < b.v;
    }

    static inline const xmlChar * xml_name() { return (const xmlChar *) "str"; }
    void read_xml(xmlNodePtr node);
    void write_xml(xmlwriter & writer) const;

    void dump_text(std::ostream & os) const;
 
  protected:
    elem(const std::string & v_, int pos_) : pos(pos_), v(v_) {}
  };
#endif

  bool inf;
  std::map<int, std::string> v;
  //  std::set<elem> v;


  // default constructor return one()
  inline string_output(bool _inf = false) : inf(_inf), v() {}
  inline string_output(xmlNodePtr node) : inf(false), v() { read_xml(node); }
  inline string_output(const std::string & text) : inf(false), v() { read_text(text); }

  /* delay the output, increment pos by one to keep track of the position
   * of the matching (word|syntagm) in the matching sequence
   */

  string_output delay(int del = 1) const;

  void set_delay(int del = 1);

  // mult: string concatenation: union
  static string_output mult(const string_output & a, const string_output & b);
  // plus: prefix: intersection
  static string_output plus(const string_output & a, const string_output & b);
  // minus: (mult^-1) suffix: difference
  static string_output minus(const string_output & a, const string_output & b);


  string_output & operator*=(const string_output & b);

  // zero: inf ensemble de tous les elements
  static inline string_output zero() { return string_output(true); }
  // one: ensemble vide
  static inline string_output one()  { return string_output(false); }

  inline bool operator<(const string_output & b) const {
    if (inf) {
      if (b.inf) {
        return false;
      } else { return true; }
    }
    if (b.inf) { return false; }
    return v < b.v;
  }


  //static inline const char * xml_name() { return "string_output"; }
  void read_xml(xmlNodePtr node);
  void write_xml(xmlwriter & writer) const;

  void read_text(const std::string & text); // read from hand-written grammar
  void dump_text(std::ostream & os) const;
};



inline bool operator!=(const string_output & a, const string_output & b) {
  return (a < b) || (b < a);
}

inline std::ostream & operator<<(std::ostream & os, const string_output & o) {
  o.dump_text(os); return os;
}


#endif

