#include <iostream>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>

#include <outilex/lingdef.h>
#include <outilex/string_transducer.h>
#include <outilex/generic_fst.h>
#include <outilex/epsilon_removal.h>
#include <outilex/fsa-prune.h>


using namespace std;
using namespace boost;

namespace fs = boost::filesystem;

namespace {

struct is_epsilon {

  pos_def * pos_epsilon;

  is_epsilon(pos_def * pos) : pos_epsilon(pos) {}
  bool operator()(const lexical_mask & m) const { return m.get_pos() == pos_epsilon; }
};


char * progname;
void usage() {
  cout << "usage: " << progname << " [-r] -l <lingdef> <fst>\n";
  exit(0);
}

} // namespace ""


int main(int argc, char ** argv) try {

  fs::path lingdefpath, ipath, opath;
  bool remove_epsilon = false;

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-r") {

      remove_epsilon = true;

    } else if (arg == "-h") {
    
      usage();
    
    } else {
      ipath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }


  if (lingdefpath.empty() || ipath.empty()) { cerr << progname << ": bad args\n"; exit(1); }

  ling_def lingdef(lingdefpath);

  opath = fs::change_extension(ipath, ".sfst");

  generic_fst gfst(ipath);
  string_transducer sfst(gfst, & lingdef);

  if (remove_epsilon) {
    cerr << "epsilon removal\n";
    fst_remove_epsilon(sfst, is_epsilon(lingdef.epsilon_pos()));
    fsa_prune(sfst);
  }
  sfst.write(opath);

} catch (exception & e) {
  cerr << "fatal exception : " << e.what() << endl;
  exit(1);
} catch (...) {
  cerr << "ouch!\n"; exit(1);
}

