#ifndef _TOKEN_H_
#define _TOKEN_H_

#include <string>

#include <outilex/xml.h>


struct token {

  typedef enum { word, punctuation, numeric, other_type } token_type;
  typedef enum { min = 0, upper, capit, other_case } case_type;

  static char * case_names[];// = { "min", "upper", "capit", "other" };

  token() : text(), type(other_type), case_(other_case) {}
  token(xmlNodePtr node) : text(), type(other_type), case_(other_case) { read_XML(node); }

  std::string text;
  token_type type;
  case_type  case_;

  void read_XML(xmlNodePtr node);
};

#endif
