#include <boost/lexical_cast.hpp>

#include <outilex/xml.h>
#include <outilex/xml-names.h>

#include <outilex/sentence_fsa.h>


using namespace std;
using namespace boost;
using namespace xmlnames;

namespace {

typedef sentence_fsa::intern_fsa_type intern_fsa_type;

void state_read_xml(xmlNode * node, sentence_fsa & fsa, int q) {

  char * text = xmlGetConstProp(node, FINAL_ATTR);

  if (text && *text == '1') {
    fsa.set_final(q);
  }

  if (text = xmlGetConstProp(node, POS_ATTR)) {
    fsa.set_pos(q, lexical_cast<int>(text));
  }

  if (text = xmlGetConstProp(node, SIZE_ATTR)) {
    fsa.A.trans_reserve(q, lexical_cast<int>(text));
  }

  int label, to;

  node = node->children;

  while (node) {

    if (xmlStrcmp(node->name, TRANS_ELEM) == 0) {
    
      label = lexical_cast<int>(xmlGetConstProp(node, LABEL_ATTR));
      to    = lexical_cast<int>(xmlGetConstProp(node, TO_ATTR));

      fsa.A.add_trans(q, label, to);
    }
    node = node->next;
  }
}


void state_write_xml(xmlwriter & writer, const sentence_fsa & fsa, int q) {
  
  writer.start_element(STATE_ELEM);

  writer.write_attribute(ID_ATTR, lexical_cast<string>(q));
  writer.write_attribute(POS_ATTR, lexical_cast<string>(fsa.pos(q)));

  if (fsa.final(q)) { writer.write_attribute(FINAL_ATTR, "1"); }

  for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(q), end = fsa.A.trans_end(q);
       tr != end; ++tr) {
    writer.start_element(TRANS_ELEM);
    writer.write_attribute(LABEL_ATTR, lexical_cast<string>(tr->label()));
    writer.write_attribute(TO_ATTR, lexical_cast<string>(tr->to()));
    writer.end_element();
  }
  writer.end_element();
}

} // namespace ""


void sentence_fsa_read_xml(xmlNode * node, sentence_fsa & fsa, LEXIC & lexic, ling_def * lingdef) {
 
  fsa.clear();
  fsa.set_lingdef(lingdef);
  fsa.set_lexic(lexic);

  char * text;

  if (text = xmlGetConstProp(node, SIZE_ATTR)) {
    int size = lexical_cast<int>(text);
    fsa.A.reserve(size);
  }

  node = node->children;

  int qno = 0;

  while (node) {

    if (xmlStrcmp(node->name, STATE_ELEM) == 0) {

      fsa.A.resize(qno + 1);
      state_read_xml(node, fsa, qno);
      ++qno;

    } else if (! xmlNodeIsText(node) && xmlStrcmp(node->name, TEXT_ELEM) == 0) {

      text = (char *) xmlNodeGetContent(node);
      fsa.text = text;
      xmlFree(text);
    }

    node = node->next;
  }
}

void sentence_fsa_write_xml(xmlwriter & writer, const sentence_fsa & fsa) {

  int size = fsa.size();

  writer.start_element(SENTENCE_FSA_ELEM);
  writer.write_attribute(SIZE_ATTR, lexical_cast<string>(size));

  writer.write_element(TEXT_ELEM, fsa.text);

  for (int q = 0; q < size; ++q) {
    state_write_xml(writer, fsa, q);
  }
  writer.end_element();
}

