#include <iostream>
#include <sstream>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/progress.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/scoped_ptr.hpp>

#include <outilex/text_fsa.h>
#include <outilex/lingdef.h>
#include <outilex/sentence_fsa.h>
#include <outilex/fsa-dump_dot.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;


void usage(ostream & os = cerr, int status = 1) {
  os << "usage: " << progname << " -l <lingdef> [-o <output>] <txtfsa> -n <sentenceno>\n";
  exit(status);
}


int main(int argc, char ** argv) try {

  fs::path lingdefpath, textpath, opath;
  int sentenceno = 0;

  char * text = getenv("LINGDEF");

  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }

  progname = *argv;
  argv++, argc--;

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage(cout, 0);

    } else if (arg == "-l") {

      argv++, argc--;
      if (! argc) { usage(); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-o") {
    
      argv++, argc--;
      if (! argc) { usage(); }
      opath = fs::path(*argv, fs::native);
 
    } else if (arg == "-n") {
    
      argv++, argc--;
      if (! argc) { usage(); }
      sentenceno = lexical_cast<int>(*argv);
 
    } else {
      textpath = fs::path(*argv, fs::native);
    }
    argv++, argc--;    
  }

  if (lingdefpath.empty() || textpath.empty()) { usage(); }

  if (opath.empty()) {
    opath = fs::path("sentence-" + lexical_cast<string>(sentenceno) + ".dot");
  }


  ling_def lingdef(lingdefpath);

  scoped_ptr<itext_fsa> p_itext(new_itext_fsa(textpath, & lingdef));
  itext_fsa & itext = *p_itext;

  fs::ofstream os(opath);
  if (! os) { cerr << "unable to open " << opath.string() << endl; exit(1); }


  if (! itext.seek(sentenceno)) {
    cerr << "unable to find sentence #" << sentenceno << endl;
    exit(1);
  }

  sentence_fsa fsa;
  itext >> fsa;

  if (! itext) {
    cerr << "unable to load sentence fsa\n";
    exit(1);
  }

  cerr << "fsa loaded\n";
  cerr << "dot..\n";

  fsa_dump_dot(fsa, os);

} catch (exception & e) {
  cerr << "fatal error: exception caught: " << e.what() << endl;
  exit(1);
}
