#include <iostream>

#include <boost/filesystem/path.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/timer.hpp>
#include <boost/progress.hpp>
#include <boost/lexical_cast.hpp>

#include <outilex/lingdef.h>
#include <outilex/sentence_fsa.h>
#include <outilex/bin_text_fsa.h>

#include <outilex/text_fsa.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;

void usage() {
  cout << "usage: " << progname << " [-o <out>] [-lexsize <size>] <txtfsa>\n";
  exit(0);
}



int main(int argc, char ** argv) try {

  fs::path txtpath, opath, lingdefpath;
  int maxsize = 500000; // 500000 mots

  char * bla = getenv("LINGDEF");
  if (bla) {
    lingdefpath = fs::path(bla);
  }

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage();

    } else if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      lingdefpath = fs::path(*argv);

    } else if (arg == "-lexsize") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      maxsize = lexical_cast<int>(*argv);

    } else if (arg == "-o") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      opath = fs::path(*argv);

    } else {
      txtpath = fs::path(arg);
    }

    argv++, argc--;
  }

  if (lingdefpath.empty() || txtpath.empty()) {
    cerr << "bad args\n"; exit(1);
  }

  if (opath.empty()) {
    opath = txtpath.branch_path() / (txtpath.leaf() + ".out");
  }


  ling_def lingdef(lingdefpath);

  scoped_ptr<itext_fsa> p_itext(new_itext_fsa(txtpath, & lingdef));
  itext_fsa & itext = *p_itext;

  int total = itext.size();

  bin_otext_fsa otext(opath, total);

  timer tmr;
  progress_display progress(total, cout);

  sentence_fsa fsa;
  int sentenceno = 0, nblock = 0;


  vector<sentence_fsa> tab;
  mutable_lexic mlexic;
  LEXIC lexic;

  while (itext >> fsa) { 

    tab.clear();
    mlexic.clear();
    lexic.clear();

    fsa.strip_lexic(mlexic);
    fsa.lexic = lexic;

    tab.push_back(sentence_fsa());
    tab.back().swap(fsa);

    ++sentenceno; ++progress; 

    while ((mlexic.size() < maxsize)
           && (itext >> fsa)) {

      fsa.strip_lexic(mlexic);
      fsa.lexic = lexic;

      tab.push_back(sentence_fsa());
      tab.back().swap(fsa);

      ++sentenceno; ++progress; 
    }

    lexic = mlexic;
    for (int i = 0; i < tab.size(); ++i) {
      tab[i].lexic = lexic;
      otext << tab[i];
    }
    ++nblock;
  }

  cout << "done. " << sentenceno << "/" << total << " sentences (" << nblock << " blocks). "
    << tmr.elapsed() << "s.\n";

} catch (exception & e) {
  cerr << "fatal error : " << e.what() << endl;
  exit(1);
}

