#ifndef _XML_TEXT_FSA_H_
#define _XML_TEXT_FSA_H_

#include <boost/filesystem/path.hpp>

#include <outilex/text_fsa.h>

#include <outilex/xmlReader.h>
#include <outilex/lexic.h>

class ling_def;
class sentence_fsa;

class xml_itext_fsa : public itext_fsa {

  boost::filesystem::path path;
  xmlreader reader;
  ling_def * lingdef;
  LEXIC lexic;

  int size_;
  int pos_;

public:

  xml_itext_fsa(const boost::filesystem::path & path, ling_def * ldef)
    : itext_fsa(), path(), reader(), lingdef(ldef), size_(-1), pos_(-1) { open(path); }

  void open(const boost::filesystem::path & path);
  void close();

  int size() const { return size_; }

  bool read_next(sentence_fsa & fsa);

  int tell() const { return pos_; }
  bool seek(int pos);
  void rewind();

  bool ok() const { return reader && (pos_ != -1); }
};

inline xml_itext_fsa & operator>>(xml_itext_fsa & itext, sentence_fsa & fsa) {
  itext.read_next(fsa); return itext;
}


class xml_otext_fsa : public otext_fsa {

  xmlwriter writer;
  LEXIC lexic;

public:

  xml_otext_fsa(const boost::filesystem::path & path, int size = -1, int compression = 0)
    : writer(), lexic() { open(path, size, compression); }

  ~xml_otext_fsa() { close(); }

  void open(const boost::filesystem::path & path, int size = -1, int compression = 0);
  void close();

  void write(const sentence_fsa & fsa);

  bool ok() { return writer; }
};

inline xml_otext_fsa & operator<<(xml_otext_fsa & text, const sentence_fsa & fsa) {
  text.write(fsa); return text;
}

#endif
