#ifndef _SYNTREF_H_
#define _SYNTREF_H_

#include <iostream>
#include <iterator>
#include <vector>
#include <outilex/xmlWriter.h>

struct syntref {
  int qno; int transno;

  inline syntref() : qno(-1), transno(0) {}
  inline syntref(int q, int trans) : qno(q), transno(trans) {}
  inline syntref(xmlNodePtr node) : qno(), transno() { read_XML(node); }

  inline void dump(std::ostream & os) const {
    os << '(' << qno << ", " << transno << ')';
  }

  void write_XML(xmlwriter & writer) const;
  void read_XML(xmlNodePtr node);
};

typedef std::vector<syntref> synt_path_type;

inline bool operator<(const syntref & a, const syntref & b) {
  if (a.qno != b.qno) { return a.qno < b.qno; }
  return a.transno < b.transno;
}

inline bool operator==(const syntref & a, const syntref & b) {
  return a.qno == b.qno && a.transno == b.transno; 
}

inline bool operator!=(const syntref & a, const syntref & b) {
  return a.qno != b.qno || a.transno != b.transno;
}

inline std::ostream & operator<<(std::ostream & os, const syntref & sref) {
  sref.dump(os); return os;
}

inline std::ostream & operator<<(std::ostream & os, const synt_path_type & path) {
  std::copy(path.begin(), path.end(), std::ostream_iterator<syntref>(os));
  return os;
}


inline bool operator==(const synt_path_type & a, const synt_path_type & b) {
  if (a.size() != b.size()) { return false; }
  for (int i = 0; i < a.size(); ++i) {
    if (a[i] != b[i]) { return false; }
  }
  return true;
}

inline bool operator!=(const synt_path_type & a, const synt_path_type & b) {
  if (a.size() != b.size()) { return true; }
  for (int i = 0; i < a.size(); ++i) {
    if (a[i] != b[i]) { return true; }
  }
  return false;
}

#endif

