#ifndef _LEXIC_H_
#define _LEXIC_H_

#include <boost/shared_ptr.hpp>

#include <outilex/lexico_hash_table.h>
#include <outilex/lexical_mask.h>


struct mutable_lexic {

  lexico_hash_table<lexical_mask> tab;

  mutable_lexic() : tab() {}

  int size() const {
    return tab.size();
  }

  void swap(mutable_lexic & lexic) { tab.swap(lexic.tab); }

  const lexical_mask & operator[](int idx) const { return tab[idx]; }

  void reserve(int size) { tab.reserve(size); }

  void clear() { tab.clear(); }

  int add(const lexical_mask & m);
};


struct LEXIC {

  struct lexic_imp {
    lexic_imp() : tab() {}
    std::vector<lexical_mask> tab;
    //lexico_hash_table<lexical_mask> tab;
  };

  boost::shared_ptr<lexic_imp> lex;

  LEXIC() : lex(new lexic_imp()) {}
  
  LEXIC(const mutable_lexic & lexic);

  int size() const {
    return lex->tab.size();
  }

  void swap(LEXIC & lexic) { lex.swap(lexic.lex); }

  lexical_mask & operator[](int idx) {
    return lex->tab[idx];
  }

  const lexical_mask & operator[](int idx) const {
    return lex->tab[idx];
  }

  void reserve(int size) { lex->tab.reserve(size); }

  void resize(int size) { lex->tab.resize(size); }

  void clear() { lex.reset(new lexic_imp()); }

//  int add(const lexical_mask & m);

  bool operator==(const LEXIC & b) const { return lex == b.lex; }

  bool operator!=(const LEXIC & b) const { return lex != b.lex; }
};


#endif
