#include <boost/lexical_cast.hpp>
#include <outilex/lexic.h>

using namespace std;
using namespace boost;


int mutable_lexic::add(const lexical_mask & m) {
  return tab.add_if_not_here(lexical_cast<string>(m), m);
}


LEXIC::LEXIC(const mutable_lexic & lexic) : lex(new lexic_imp()) {

  int size = lexic.size();
  lex->tab.resize(size);
  for (int i = 0; i < size; ++i) {
    lex->tab[i] = lexic[i];
  }
}

