#include <iostream>
#include <sstream>
#include <outilex/sentence_fsa.h>
#include <outilex/bin_format_sentence_fsa.h>
#include <outilex/serialize.h>

using namespace std;

namespace {

typedef sentence_fsa::intern_fsa_type intern_fsa_type;

void state_skip_bin(istream & is, int labelsize, int tosize) {

  int n;
  read_int(is, n);

  read_int_mb(is, n);

  n = n >> 2;

  n = n * (labelsize + tosize);
  is.ignore(n);
}

void state_read_bin(istream & is, sentence_fsa & fsa, int q, int labelsize, int tosize) {

  int n;
  read_int(is, n);
  fsa.set_pos(q, n);

  read_int_mb(is, n);

  if (n % 2) { fsa.set_final(q); }
  n = n >> 2;

  fsa.A.trans_reserve(q, n);
  
  int label, to;
  for (int i = 0; i < n; ++i) {
    read_intN(is, label, labelsize);
    read_intN(is, to, tosize);
    fsa.A.add_trans(q, label, to);
  }
}


void state_write_bin(ostream & os, const sentence_fsa & fsa, int q, int labelsize, int tosize) {

  write_int(os, fsa.pos(q));

  int ntrans = fsa.A.trans_size(q) << 2;
  if (fsa.final(q)) { ntrans |= 1; }
 
  //  assert(ntrans < 0x8000);

  write_int_mb(os, ntrans);

  for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(q), end = fsa.A.trans_end(q);
       tr != end; ++tr) {

    write_intN(os, tr->label(), labelsize);
    write_intN(os, tr->to(), tosize);
  }
}


} // namespace ""


void sentence_fsa_skip_bin(istream & is) {

  int size, labelsize, tosize;

  string text;
  read_string(is, text);
  
  read_int(is, labelsize);
  read_int(is, size);

  tosize = n_bytes_needed(size);

  for (int q = 0; q < size; ++q) {
    state_skip_bin(is, labelsize, tosize);
  }
}

void sentence_fsa_read_bin(istream & is, sentence_fsa & fsa, LEXIC & lexic, ling_def * lingdef) {

  //cerr << "fsa read=bin\n";

  fsa.set_lingdef(lingdef);
  fsa.set_lexic(lexic);

  fsa.A.clear();

  int size, labelsize, tosize;

  //cerr << "read text\n";

  read_string(is, fsa.text);
  
  //cerr << "text = " << fsa.text << endl;

  read_int(is, labelsize);
  read_int(is, size);

  tosize = n_bytes_needed(size);

/*
  cerr << "lexic size = " << lexic.size() << endl;
  cerr << "size = " << size << ", tosize = " << tosize << ", labelsize = " << labelsize << endl;
*/

  fsa.A.resize(size);
  for (int q = 0; q < size; ++q) {
    // cerr << "q = " << q << "/" << size << endl;
    state_read_bin(is, fsa, q, labelsize, tosize);
  }
}


void sentence_fsa_write_bin(ostream & os, const sentence_fsa & fsa) {

  int size = fsa.size();

  write_string(os, fsa.text);

  int labelsize = n_bytes_needed(fsa.lexic.size());
  int tosize = n_bytes_needed(size);

  write_int(os, labelsize);
  write_int(os, size);

  for (int q = 0; q < size; ++q) {
    state_write_bin(os, fsa, q, labelsize, tosize);
  }
}

