#ifndef _SYNTAGM_FST_H_
#define _SYNTAGM_FST_H_

#include <vector>
#include <list>
#include <outilex/synt_mask.h>
#include <outilex/syntagm_pattern.h>

/* represent a syntagmatic description used for matching with text automaton
 * init with a non determinist syntagm pattern, and determinize it
 * partially during the matching/application process
 */

class syntagm_fst {

  //typedef syntagm_pattern ndeter_fst;

public:

  typedef syntagm_pattern::input_type input_type;
  typedef syntagm_pattern::synt_input_type synt_input_type;
  typedef syntagm_pattern::output_type output_type;

  typedef syntagm_pattern::transition ndeter_transition;
  typedef std::list<ndeter_transition> ndeter_transitions;

  typedef syntagm_pattern::synt_transition ndeter_synt_transition;
  typedef std::list<ndeter_synt_transition> ndeter_synt_transitions;

  struct position {
    
    int q;
    output_type delayed;
    
    inline position(xmlNodePtr node) { read_XML(node); }
    inline position(int _q, const output_type & d) : q(_q), delayed(d) {}
    
    inline bool operator<(const position & pos) const {
      if (q != pos.q) { return q < pos.q; }
      return delayed < pos.delayed;
    }

    void write_XML(xmlwriter & writer) const;
    void read_XML(xmlNodePtr node);
  };

  typedef std::set<position> stateid;


  struct transition {

    int to_;
    input_type in_;
    output_type out_;

    transition() {}
    transition(const lexical_mask & in, const output_type & out, int to)
      : in_(in), to_(to), out_(out) { }

    inline int to() const { return to_; }

    inline input_type & in() { return in_; }
    inline const input_type & in() const  { return in_; }

    inline output_type & out() { return out_; }
    inline const output_type & out() const { return out_; }


    /* Serialisation */
    void read_XML(xmlNodePtr node, ling_def * lingdef);
    void write_XML(xmlwriter & writer) const;
  };

  typedef std::vector<transition> transitions;
  typedef transitions::iterator trans_iterator;
  typedef transitions::const_iterator const_trans_iterator;


  struct synt_transition {

    int to_;
    synt_mask in_;
    output_type out_;

    inline synt_transition() { std::cerr << "new syntransiton()!\n"; }
    inline synt_transition(xmlNodePtr node, ling_def * lingdef) { read_XML(node, lingdef); }
    inline synt_transition(const synt_mask & in, const output_type & out, int to)
      : in_(in), to_(to), out_(out) { }

    inline int to() const { return to_; }
    inline const synt_mask & in() const { return in_; }
    inline const output_type & out() const { return out_; }

    void read_XML(xmlNodePtr node, ling_def * lingdef);
    void write_XML(xmlwriter & writer) const;
  };

  // WARNING: use a list (instead of vector) because we DON'T WANT to invalidate iterator
  // during grammar application (do we?) don't work with list too ?????????
  //typedef std::list<synt_transition> synt_transitions;

  typedef std::vector<synt_transition> synt_transitions;
  typedef synt_transitions::iterator synt_trans_iterator;
  typedef synt_transitions::const_iterator const_synt_trans_iterator;

  typedef std::set<output_type> outputs_type;

  struct state {

    bool final;
    outputs_type final_outputs;

    struct info {

      outputs_type delayeds;
      ndeter_transitions ndeter_trans;      

      info() : delayeds(), ndeter_trans() {}

      // take its associated state id as argument
      void write_XML(xmlwriter & writer, int id) const;
      // return its associated state entry in info_map
      void read_XML(xmlNodePtr node, ling_def * lingdef, int & id);
      void read_XML(xmlNodePtr node, ling_def * lingdef);
    };
 
    typedef std::map<int, info> info_map;
    info_map infos;

    // determinized transitions
    transitions trans; 
    synt_transitions synt_trans;

    void read_XML(xmlNodePtr node, ling_def * lingdef);
    void write_XML(xmlwriter & writer, int id) const;

  protected:

    static inline const xmlChar * outputs_xml_name() { return (const xmlChar *) "outputs"; }
    static void write_outputs_XML(xmlwriter & writer, const outputs_type & out);
    static void read_outputs_XML(xmlNodePtr node, outputs_type & out);

    static void write_infos_XML(xmlwriter & writer, const info_map & out);
    static void read_infos_XML(xmlNodePtr node, ling_def * lingdef, info_map & out);
  };


  typedef std::map<stateid, int> state_map;


protected:

  template<typename OutputIterator>
  void extract_matching_trans(const lexical_entry & e, ndeter_transitions & ntrans,
                              OutputIterator out, lexical_mask & m,
                              const std::set<output_type> & delayed, output_type & prefix);



  /* protected */
  trans_iterator trans_begin(int q) { return states[q].trans.begin(); }

  void init_state(int q, const stateid & id);


  int add_state(const stateid & id);
  trans_iterator add_trans(int from, const input_type & in, const output_type & out, int to);

  inline const xmlChar * idmap_xml_name() { return (const xmlChar *) "state_id_map"; }
  void read_idmap_XML(xmlNodePtr node, stateid & id, int & q);
  void write_idmap_XML(xmlwriter & writer, const stateid & id, int q) const;

public:

  /* default constructor (for storage in container)*/
  syntagm_fst(ling_def * ldef = NULL) : name(), lingdef(ldef), A(ldef), states(), id2state() {}

  /* construct from a syntagm_pattern */
  inline syntagm_fst(const syntagm_pattern & pattern)
    : name(), lingdef(pattern.get_lingdef()), A(pattern.get_lingdef()), states(), id2state()
    { init(pattern); }
 
  /* construct from an XML description */
  syntagm_fst(xmlNodePtr node, ling_def * lingdef);

  void init(const syntagm_pattern & pattern);

  inline const syntagm_pattern & get_pattern() const { return A; }
  
  void clear();

  const std::string & get_name() const { return name; }

  int start() const { return 0; }

  trans_iterator find_matching_trans(int from, const lexical_entry & e);


  inline bool & final(int q) { return states[q].final; }
  inline outputs_type & final_outputs(int q) { return states[q].final_outputs; }

  inline trans_iterator trans_end(int q) { return states[q].trans.end(); }

  inline synt_trans_iterator synt_trans_begin(int q) { return states[q].synt_trans.begin(); }
  inline synt_trans_iterator synt_trans_end(int q) { return states[q].synt_trans.end(); }

  inline const synt_transition & get_synt_trans(int q, int no) const { return states[q].synt_trans[no]; }
  inline int synt_trans_size(int q) const { return states[q].synt_trans.size(); }
  


  static inline const xmlChar * xml_name() { return (const xmlChar *) "syntagm_fst"; }
  void read_XML(xmlNodePtr node, ling_def * lingdef);
  void write_XML(xmlwriter & writer) const;

protected:

  std::string name;
  ling_def * lingdef;
  syntagm_pattern A;

  std::vector<state> states;
  state_map id2state;


  struct ndeter_trans_inserter {

    ndeter_transitions & translist;
    ndeter_transitions::iterator it;
    ndeter_transition trans;

    struct proxy_t {

      ndeter_trans_inserter & I;

      proxy_t(ndeter_trans_inserter & inserter) : I(inserter) {}

      void operator=(const lexical_mask & m) {
        I.trans.in() = m;
        I.translist.insert(I.it, I.trans); 
      }
    };

    proxy_t proxy;

    ndeter_trans_inserter(ndeter_transitions & _translist, ndeter_transitions::iterator _it,
                          const ndeter_transition & t)
      : translist(_translist), it(_it), trans(t), proxy(*this) {}

    struct proxy_t & operator*() { return proxy; }

    ndeter_trans_inserter & operator++() { return *this; }
    //ndeter_lex_trans_inserter & operator++(int) { return *this; }
  };

};

#endif
