#ifndef _SYNTMASK_H_
#define _SYNTMASK_H_

#include <string>

#include <outilex/lingdef.h>
#include <outilex/syntagm_path.h>

class synt_mask {

public:

  typedef std::map<attr_def *, feat_set> dic_feats_map;
  typedef std::map<std::string, std::string> string_feats_map;

  synt_mask(syntagm_def * syntdef = NULL);

  bool match(const syntagm_path & p) const;
  static inline bool match(const syntagm_path & p, const synt_mask & m) { return m.match(p); }


  inline const std::string & get_name() const { return syntdef->get_name(); }

  void read_text(const std::string & text, ling_def * lingdef);
  void dump_text(std::ostream & os) const;

  static inline const xmlChar * xml_name() { return (const xmlChar *) "syntagm_mask"; }
  void read_XML(xmlNodePtr node, ling_def * lingdef);
  void write_XML(xmlwriter & writer) const;


protected:

  syntagm_def * syntdef;

  dic_feats_map    dic_feats;
  string_feats_map string_feats;
};

inline std::ostream & operator<<(std::ostream & os, const synt_mask & m) {
  m.dump_text(os); return os;
}

#endif
