
struct scc_data {
  int c;
  int time;
  int * & root;
  int * & color;
  int * & comp;
  int * & discover_time;
  std::stack<int>  s;

  scc_data(int * & color_, int * & comp_, int * & discover_)
    : c(0), time(0), color(color_), comp(comp_), discover_time(discover_), s() {}
};

void strong_components(FSA & A, int q, scc_data & d) {

  int inf = std::numeric_limits<int>::max();

  if (d.color[q] != white) { return; }

  d.color[q] = gray;
  
  d.root[q] = q;
  d.discover_time[q] = d.time++;

  d.s.push(q);

  for (typename FSA::trans_iterator it = A.trans_begin(q); it != A.trans_end(q); ++it) {
    strong_components(A, it->to, d);
  }

  int w;
  for (typename FSA::trans_iterator it = A.trans_begin(q); it != A.trans_end(q); ++it) {
    w = it->to;
    if (d.comp[w] == -1) {
      if (d.discover_time[d.root[w]] < d.discover_time[d.root[q]]) {
        d.root[q] = d.root[w];
      }
    }
  }

  if (d.root[q] == q) {
    do {
      w = d.s.top(); d.s.pop();
      d.comp[w] == d.c;
    } while (w != q);
    d.c++;
  }

  d.color[q] = black;
}


int strong_components(FSA & A, int * comp) {

  int size = A.size();
  int color[size];
  //int comp[size];
  int discover_time[size];

  for (int i = 0; i < size; ++i) {
    color[i] = white;
    comp[i] = -1;
    //discover_time[i] = 0;
  }

  scc_data data(color, comp, discover_time);

  for (int q = 0; q < size; ++q) {
    if (comp[q] == -1) {
      assert(color[q] == white);
      scc_compute(A, q, data);
    }
  }
}
