#ifndef _GRAMMAR_H_
#define _GRAMMAR_H_

#include <string>
#include <vector>
#include <map>

#include <boost/filesystem/path.hpp>

#include <outilex/xml.h>
#include <outilex/syntagm_fst.h>

class grammar {

public:

  typedef syntagm_fst::output_type output_type;


  grammar(ling_def * ldef) : path(), lingdef(ldef), syntagms(), synt_map(), start_graph(0) {}

  grammar(const boost::filesystem::path & fname, ling_def * lingdef);

  inline int start() const { return start_graph; }

  inline const std::string & main_name() { return syntagms[start_graph].get_name(); }

  inline int size() const { return syntagms.size(); }

  inline syntagm_fst & operator[](int idx) { return syntagms[idx]; }

  inline int get_syntagm_idx(const std::string & syntname) const {
    std::map<std::string, int>::const_iterator it = synt_map.find(syntname);
    if (it == synt_map.end()) { return -1; }
    return it->second;
  }

  int add_pattern(const boost::filesystem::path & patternpath, const std::string & pattname);

  void read(const boost::filesystem::path & fname, ling_def * lingdef);
  void read_XML(xmlNodePtr node, ling_def * lingdef);
  void write_XML(xmlwriter & writer) const;

  void write() const { write(path); } // overide
  void write(const boost::filesystem::path & fname) const;

protected:

  boost::filesystem::path path; // name of file containing the grammar
  ling_def * lingdef;

  std::vector<syntagm_fst> syntagms;
  std::map<std::string, int> synt_map;

  int start_graph;
};

#endif
