#include <iostream>
#include <fstream>
#include <stdexcept>
#include <sstream>
#include <vector>

#include <boost/progress.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>

#include <outilex/text_fsa.h>
#include <outilex/grammar.h>
#include <outilex/grammar_application.h>


using namespace std;
using namespace boost;

namespace fs = boost::filesystem;

char * progname;


void usage() {
  cerr << "usage: " << progname << " -l <lingdef> -g <grammar> [ -o <outputfile> ] <fsttxt>\n";
  exit(1);
}



int main(int argc, char ** argv) {

  fs::path itextpath, lingdefpath, grammarpath, otextpath;

  progname = *argv;

  argv++, argc--;

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-o") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      otextpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-g") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      grammarpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-h") {
    
      usage();
    
    } else {
      itextpath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }

  if (itextpath.empty() || lingdefpath.empty() || grammarpath.empty()) { usage(); }

  if (otextpath.empty()) {
    otextpath = itextpath.branch_path() / (itextpath.leaf() + ".out");
  }


  try {

    ling_def * lingdef = new ling_def(lingdefpath);

    itext_fsa itext(itextpath, lingdef);
    int total = itext.size();

    otext_fsa otext(otextpath, total);

    grammar grm(grammarpath, lingdef);

    string mainname = grm.main_name();

    sentence_fsa fsa;

    int sentenceno = 0, nbmatches = 0;
    progress_display show_progress(total, cout);

    while (itext >> fsa) {

      pair<int, int> p = apply_grammar(fsa, grm);
      nbmatches += -(p.first -p.second);

      otext << fsa;
      
      ++sentenceno;
      ++show_progress;
    }

    cout << "done. " << sentenceno << " sentences parsed. " << nbmatches << " matches found.\n";

    grammarpath = grammarpath.branch_path() / (grammarpath.leaf() + ".new");
    cout << "saving partially determinized grammar in " << grammarpath.string() << endl; 
    grm.write(grammarpath);

  } catch (exception & e) {

    cerr << "exception caught :" << e.what() << endl; exit(1);
  
  } catch (...) { cerr << "caught an OVNI?\n"; exit(1); }
  

  return 0;
}

