#include <iostream>
#include <stack>

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/convenience.hpp>
                       
#include "FST2_to_syntagm_pattern.h"
#include "lingdef.h"
#include "grammar.h"

using namespace std;

namespace fs = boost::filesystem;


char * progname;


void usage() {
  cerr << "usage: " << progname << " -l <lingdef> <fst2>\n";
  exit(1);
}


int main(int argc, char ** argv) {

  string fstname, lingdefname;
  bool validate = false;

  progname = *argv;

  argv++, argc--;

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      lingdefname = *argv;
    
    } else if (arg == "-h") {
    
      usage();
    
    } else {
      fstname = arg;
    }

    argv++, argc--;
  }

  if (fstname.empty() || lingdefname.empty()) { usage(); }


  try {

    ling_def * lingdef = new ling_def(lingdefname);

    fs::path fstpath(fstname, fs::native);
    cerr << "fstpath=" << fstpath.native_file_string() << endl;

    if (! fs::exists(fstpath)) {
      cerr << "error: unable to find " << fstpath.native_file_string() << "file\n";
      exit(1);
    }

    fs::path patternpath = fs::change_extension(fstpath, ".pat");
    cerr << "patternpath=" << patternpath.native_file_string() << endl;

    cerr << "compiling " << fstpath.native_file_string() << " to "
      << patternpath.native_file_string() << "...\n";

    fst2pattern(fstpath, patternpath, lingdef);

    cerr << "compilation done.\n";

  } catch (exception & e) {
  
    cerr << "error: excepion caught : " << e.what() << endl;
    return 1;
  }

  cout << "done.\n";
}

