#include <iostream>
#include <boost/filesystem/path.hpp>
#include <outilex/rtn_pattern.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/xml_format_lexmask.h>
#include <outilex/xml_format_fst.h>

using namespace std;
namespace fs = boost::filesystem;
using namespace xmlnames;

struct rtn_pattern_xml_formater {

  ling_def * ldef;

  rtn_pattern_xml_formater(ling_def * l) : ldef(l) {}

  const char * fst_name() { return RTN_PATTERN_ELEM; }
  
  void read_fst_data(xmlNode * node, rtn_pattern & T) {
    node = node->children;
    while (node) {
      if (xmlStrcmp(node->name, "name") == 0) {
        char * text = (char * ) xmlNodeGetContent(node);
        T.name = text;
        xmlFree(text);
        return;
      }
      node = node->next;
    }
    cerr << "rtn_pattern: read xml: no name?\n";
  }
  void write_fst_data(xmlwriter & writer, const rtn_pattern & T) {
    writer.write_element("name", T.name);
  }

  void read_fst_state_data(xmlNode * n, rtn_pattern & T, int q) {}
  void write_fst_state_data(xmlwriter & writer, const rtn_pattern & T, int q) {}

  void read_in(xmlNode * node, rtn_input_type & in) {
    node = node->children;
    while (node) {
      if (node->type == XML_ELEMENT_NODE) {
        in.read_xml(node, ldef);
        return;
      }
      node = node->next;
    }
    cerr << "rtn_pattern::read_in: no input found?\n";
  }

  void write_in(xmlwriter & writer, const rtn_input_type & in) {
    in.write_xml(writer);
  }


  void read_out(xmlNode * node, string & out) {
    char * text = (char *) xmlNodeGetContent(node);
    out = text;
    xmlFree(text);
  }
  void write_out(xmlwriter & writer, const string & out) {
    writer.write_string(out);
  }
                        
};

rtn_pattern::rtn_pattern(const fs::path & path, ling_def * ldef)
  : fst_type(), lingdef(ldef) {

  xml_read_fst(path, *this, rtn_pattern_xml_formater(ldef));
}


void rtn_pattern::read(const fs::path & path, ling_def * ldef) {
  clear();
  lingdef = ldef;
  xml_read_fst(path, *this, rtn_pattern_xml_formater(ldef));
}

void rtn_pattern::write(const fs::path & path) const {
  xml_write_fst(path, *this, rtn_pattern_xml_formater(lingdef));
}

void rtn_pattern::write_xml(xmlwriter & writer) const {
  xml_write_fst(writer, *this, rtn_pattern_xml_formater(lingdef));
}

void rtn_pattern::read_xml(xmlNode * node, ling_def * ldef) {
  lingdef = ldef;
  xml_read_fst(node, *this, rtn_pattern_xml_formater(ldef));
}


