#include <string>
#include <boost/variant.hpp>

#include <outilex/lingdef.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/rtn_input_type.h>

using namespace std;
using namespace boost;
using namespace xmlnames;


rtn_input_type::rtn_input_type(const std::string & text, ling_def * ldef) : type(LEXMASK), v() {

  if (text.empty()) { throw runtime_error("parse error: empty input_type text description"); }
  
  if (text.size() > 1 && text[0] == ':') { // subgraph call (e.g. :SN -> SN)

    type = SUBCALL;
    v = text.substr(1);

  } else if (text == "<E>") {

    type = EPSILON;
    v = "";

  } else { // lexical_mask

    lexical_mask m(text, ldef);

    if (m.get_pos() == ldef->epsilon_pos()) {
      type = EPSILON;
      v = "";
    } else {
      type = LEXMASK;
      v = m;
    }
  }
}


void rtn_input_type::write_xml(xmlwriter & writer) const {
  
  if (type == LEXMASK) {

    boost::get<lexical_mask>(v).write_XML(writer);

  } else if (type == EPSILON) {

    writer.write_element(EPSILON_ELEM, "");

  } else {
    writer.write_element(SUBCALL_ELEM, boost::get<string>(v));
  }
}


void rtn_input_type::read_xml(xmlNodePtr node, ling_def * lingdef) {

  char * text;

  if (xmlStrcmp(node->name, SUBCALL_ELEM) == 0) {
 
    type = SUBCALL;
    text = (char *) xmlNodeGetContent(node);
    v = text;
    xmlFree(text);

  } else if (xmlStrcmp(node->name, EPSILON_ELEM) == 0) {
    type = EPSILON;
    v = "";
  } else {
  
    lexical_mask m(node, lingdef);
    if (m.get_pos() == lingdef->epsilon_pos()) {
      type = EPSILON;
      v = ""; 
    } else {
      type = LEXMASK;
      v = m;
    }
  }
}

void rtn_input_type::dump(std::ostream & os) const {

  if (type == SUBCALL) {
    os << ":" << boost::get<string>(v);
  
  } else if (type == LEXMASK) {
    os << boost::get<lexical_mask>(v); 
  
  } else {
    assert(type == EPSILON);
    os << "<epsilon>";
  }
}
